package com.atlassian.crowd.plugin.rest.service.util;

import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import static com.google.common.base.Preconditions.checkNotNull;

public class RestAuthSessionHelperUtil {
    /**
     * @param request request to fetch string from
     * @param key     key of the string to fetch
     * @return the string which was stored in the request's session under the given key, or null if there was no session
     * or there was no value for that key
     * @throws ClassCastException if the value stored in the request's session under the given key is not a string
     */
    @Nullable
    protected static String fetchStringFromRequestSession(HttpServletRequest request, String key) {
        checkNotNull(request);
        checkNotNull(key);
        final HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (String) session.getAttribute(key);
    }
}
