package com.atlassian.crowd.plugin.rest.service.util;

import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

import com.google.common.annotations.VisibleForTesting;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Utility for setting and retrieving the authenticated user's name from the {@link javax.servlet.http.HttpServletRequest}.
 *
 * @since v2.1
 */
public class AuthenticatedUserUtil extends RestAuthSessionHelperUtil {
    @VisibleForTesting
    public static final String USER_ATTRIBUTE_KEY = "com.atlassian.crowd.authenticated.user.name";

    private AuthenticatedUserUtil() {
    }

    /**
     * Returns the username from the {@link javax.servlet.http.HttpSession}, or <tt>null</tt> if no username was found.
     *
     * @param request HTTP servlet request
     * @return name of the authenticated user, <tt>null</tt> if no username was found
     */
    @Nullable
    public static String getAuthenticatedUser(final HttpServletRequest request) {
        return fetchStringFromRequestSession(request, USER_ATTRIBUTE_KEY);
    }

    /**
     * Sets the name of the authenticated application as an attribute of the {@link javax.servlet.http.HttpSession}.
     *
     * @param request  HTTP servlet request
     * @param username name of the authenticated user
     */
    public static void setAuthenticatedUser(final HttpServletRequest request, final String username) {
        checkNotNull(username);
        request.getSession().setAttribute(USER_ATTRIBUTE_KEY, username);
    }
}
