package com.atlassian.crowd.plugin.rest.provider;

import com.atlassian.crowd.common.util.AdditionalHeaders;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;

import javax.ws.rs.core.SecurityContext;
import java.util.Optional;

public class RestUsernameHeaderFilter implements ContainerResponseFilter, ResourceFilter {

    @Override
    public ContainerResponse filter(ContainerRequest containerRequest, ContainerResponse containerResponse) {
        final Optional<SecurityContext> securityContext = Optional.ofNullable(containerRequest.getSecurityContext());

        securityContext.map(SecurityContext::getUserPrincipal).ifPresent(principal ->
                containerResponse.getHttpHeaders().putSingle(AdditionalHeaders.HEADER_X_AUSERNAME, principal.getName()));

        return containerResponse;
    }

    @Override
    public ContainerRequestFilter getRequestFilter() {
        return null;
    }

    @Override
    public ContainerResponseFilter getResponseFilter() {
        return this;
    }
}
