package com.atlassian.crowd.plugin.rest.provider;

import com.atlassian.crowd.plugin.rest.entity.page.RestPageRequest;
import com.atlassian.crowd.plugin.rest.entity.page.SimpleRestPageRequest;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.PerRequestTypeInjectableProvider;
import org.apache.commons.lang3.math.NumberUtils;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
public class RestPageRequestProvider extends PerRequestTypeInjectableProvider<Context, RestPageRequest> {
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_LIMIT = 50;
    public static final String START_PARAM = "start";
    public static final String LIMIT_PARAM = "limit";

    public RestPageRequestProvider() {
        super(RestPageRequest.class);
    }

    @Override
    public Injectable<RestPageRequest> getInjectable(ComponentContext componentContext, Context context) {
        return new AbstractHttpContextInjectable<RestPageRequest>() {
            @Override
            public RestPageRequest getValue(HttpContext httpContext) {
                final MultivaluedMap<String, String> params = httpContext.getRequest().getQueryParameters();
                final int start = NumberUtils.toInt(params.getFirst(START_PARAM), DEFAULT_START);
                final int limit = NumberUtils.toInt(params.getFirst(LIMIT_PARAM), DEFAULT_LIMIT);
                return new SimpleRestPageRequest(start, limit);
            }
        };
    }
}