package com.atlassian.crowd.plugin.rest.provider;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import java.util.concurrent.ExecutionException;

@Provider
public class JAXBContextResolver implements ContextResolver<JAXBContext> {
   private static final Cache<Class, JAXBContext> CACHE = CacheBuilder.newBuilder().weakKeys().softValues().build();
   @Override
   public JAXBContext getContext(Class<?> clz) {
       try {
           return CACHE.get(clz, () -> JAXBContext.newInstance(clz));
       } catch (ExecutionException e) {
           throw new RuntimeException(e.getCause());
       }
   }
}