package com.atlassian.crowd.plugin.rest.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;

/**
 * Maps an {@link com.atlassian.crowd.exception.InvalidMembershipException} to a {@link javax.ws.rs.core.Response}.
 */
@Provider
public class InvalidMembershipExceptionMapper implements ExceptionMapper<InvalidMembershipException> {
    @Override
    public Response toResponse(final InvalidMembershipException exception) {
        return Response.status(Response.Status.BAD_REQUEST).entity(ErrorEntity.of(exception)).build();
    }
}
