package com.atlassian.crowd.plugin.rest.exception.mapper;

import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.exception.DirectoryTestFailedException;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class DirectoryTestFailedExceptionMapper implements ExceptionMapper<DirectoryTestFailedException> {
    @Override
    public Response toResponse(DirectoryTestFailedException e) {
        final ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(e.getCause()), e.getMessage());
        return Response.status(Response.Status.CONFLICT).entity(errorEntity).build();
    }
}
