package com.atlassian.crowd.plugin.rest.exception.mapper;

import com.atlassian.crowd.exception.DirectoryMappingNotFoundException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class DirectoryMappingNotFoundExceptionMapper implements ExceptionMapper<DirectoryMappingNotFoundException> {
    @Override
    public Response toResponse(DirectoryMappingNotFoundException e) {
        final ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(e), e.getMessage());
        return Response.status(Response.Status.NOT_FOUND).entity(errorEntity).build();
    }
}