package com.atlassian.crowd.plugin.rest.exception.mapper;

import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.exception.DirectoryMappingConstraintException;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class DirectoryMappingConstraintExceptionMapper implements ExceptionMapper<DirectoryMappingConstraintException> {
    @Override
    public Response toResponse(DirectoryMappingConstraintException e) {
        return Response.status(Response.Status.CONFLICT).entity(new ErrorEntity(ErrorEntity.ErrorReason.of(e), e.getMessage())).build();
    }
}