package com.atlassian.crowd.plugin.rest.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import com.atlassian.crowd.exception.ApplicationAlreadyExistsException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;

/**
 * Maps an {@link ApplicationAlreadyExistsException} to a {@link javax.ws.rs.core.Response}.
 */
@Provider
public class ApplicationAlreadyExistsExceptionMapper implements ExceptionMapper<ApplicationAlreadyExistsException> {
    @Override
    public Response toResponse(ApplicationAlreadyExistsException exception) {
        final ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(exception), ExceptionMapperUtil.stripNonValidXMLCharacters(exception.getMessage()));
        return Response.status(Response.Status.CONFLICT).entity(errorEntity).build();
    }
}
