package com.atlassian.crowd.plugin.rest.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import com.atlassian.crowd.manager.application.AliasAlreadyInUseException;

@Provider
public class AliasAlreadyInUseExceptionMapper implements ExceptionMapper<AliasAlreadyInUseException> {
    @Override
    public Response toResponse(AliasAlreadyInUseException exception) {
        Response.ResponseBuilder responseBuilder = Response.status(Response.Status.CONFLICT);
        if (exception.getApplicationName() != null) {
            responseBuilder.entity(exception.getApplicationName());
        }
        return responseBuilder.build();
    }
}
