package com.atlassian.crowd.plugin.rest.exception;

import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.validator.ValidationError;

import java.util.List;

/**
 * Exception to be generated whenever an entity's validation fails. It contains the list of validation errors
 *
 * @since 3.2.0
 */
public class ValidationFailedException extends CrowdException {

    private List<ValidationError> errorMessages;

    public ValidationFailedException(List<ValidationError> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public List<ValidationError> getErrorMessages() {
        return errorMessages;
    }
}
