package com.atlassian.crowd.plugin.rest.entity.sso;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class IdpSamlConfigurationEntity {
    @JsonProperty("issuer")
    private final String issuer;

    @JsonProperty("ssoUrl")
    private final String ssoUrl;

    @JsonProperty("certificateFormat")
    private final CertificateFormat certificateFormat;

    @JsonProperty("certificate")
    private final String certificate;

    @JsonProperty("expirationDate")
    private final Long expirationDate;

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public IdpSamlConfigurationEntity(@JsonProperty("issuer") String issuer, @JsonProperty("ssoUrl") String ssoUrl, @JsonProperty("certificateFormat") CertificateFormat certificateFormat, @JsonProperty("certificate") String certificate, @JsonProperty("expirationDate") Long expirationDate) {
        this.issuer = issuer;
        this.ssoUrl = ssoUrl;
        this.certificateFormat = certificateFormat;
        this.certificate = certificate;
        this.expirationDate = expirationDate;
    }

    public String getIssuer() {
        return issuer;
    }

    public String getSsoUrl() {
        return ssoUrl;
    }

    public CertificateFormat getCertificateFormat() {
        return certificateFormat;
    }

    public String getCertificate() {
        return certificate;
    }

    public Long getExpirationDate() {
        return expirationDate;
    }

    public static IdpSamlConfigurationEntity.Builder builder() {
        return new IdpSamlConfigurationEntity.Builder();
    }

    public static IdpSamlConfigurationEntity.Builder builder(IdpSamlConfigurationEntity data) {
        return new IdpSamlConfigurationEntity.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        IdpSamlConfigurationEntity that = (IdpSamlConfigurationEntity) o;

        return Objects.equals(this.getIssuer(), that.getIssuer()) &&
                Objects.equals(this.getSsoUrl(), that.getSsoUrl()) &&
                Objects.equals(this.getCertificateFormat(), that.getCertificateFormat()) &&
                Objects.equals(this.getCertificate(), that.getCertificate()) &&
                Objects.equals(this.getExpirationDate(), that.getExpirationDate());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getIssuer(), getSsoUrl(), getCertificateFormat(), getCertificate(), getExpirationDate());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("issuer", getIssuer())
                .add("ssoUrl", getSsoUrl())
                .add("certificateFormat", getCertificateFormat())
                .add("certificate", getCertificate())
                .add("expirationDate", getExpirationDate())
                .toString();
    }

    public static final class Builder {

        private String issuer;
        private String ssoUrl;
        private CertificateFormat certificateFormat;
        private String certificate;
        private Long expirationDate;

        private Builder() {
        }

        private Builder(IdpSamlConfigurationEntity initialData) {
            this.issuer = initialData.getIssuer();
            this.ssoUrl = initialData.getSsoUrl();
            this.certificateFormat = initialData.getCertificateFormat();
            this.certificate = initialData.getCertificate();
            this.expirationDate = initialData.getExpirationDate();
        }

        public Builder setIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder setSsoUrl(String ssoUrl) {
            this.ssoUrl = ssoUrl;
            return this;
        }

        public Builder setCertificateFormat(CertificateFormat certificateFormat) {
            this.certificateFormat = certificateFormat;
            return this;
        }

        public Builder setCertificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public Builder setExpirationDate(Long expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public IdpSamlConfigurationEntity build() {
            return new IdpSamlConfigurationEntity(issuer, ssoUrl, certificateFormat, certificate, expirationDate);
        }
    }
}
