package com.atlassian.crowd.plugin.rest.entity.directory;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.plugin.rest.entity.admin.directory.DirectoryData;
import com.atlassian.crowd.plugin.rest.entity.admin.user.UserData;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

public class GroupAdministrationMappingRestDTO {

    @JsonProperty("entity")
    private final DirectoryEntityRestDTO entity;

    @JsonProperty("name")
    private final String name;

    @JsonProperty("displayName")
    private final String displayName;

    @JsonProperty("directory")
    private final DirectoryData directory;

    @JsonProperty("email")
    private final String email;

    @JsonProperty("active")
    private final Boolean active;

    public static GroupAdministrationMappingRestDTO fromGroup(Group group, Directory directory) {
        return fromGroup(group, DirectoryData.fromDirectory(directory));
    }

    public static GroupAdministrationMappingRestDTO fromGroup(Group group, DirectoryData directoryData) {
        return GroupAdministrationMappingRestDTO.builder()
                .setEntity(DirectoryEntityRestDTO.fromGroup(group))
                .setName(group.getName())
                .setActive(group.isActive())
                .setDirectory(directoryData)
                .build();
    }

    public static GroupAdministrationMappingRestDTO fromUser(User user, Directory directory) {
        return fromUser(user, DirectoryData.fromDirectory(directory));
    }

    public static GroupAdministrationMappingRestDTO fromUser(User user, DirectoryData directoryData) {
        return GroupAdministrationMappingRestDTO.builder()
                .setEntity(DirectoryEntityRestDTO.fromUser(user))
                .setName(user.getName())
                .setDisplayName(user.getDisplayName())
                .setEmail(user.getEmailAddress())
                .setActive(user.isActive())
                .setDirectory(directoryData)
                .build();
    }

    public static GroupAdministrationMappingRestDTO fromUserData(UserData userData) {
        return GroupAdministrationMappingRestDTO.builder()
                .setEntity(DirectoryEntityRestDTO.fromUserData(userData))
                .setName(userData.getUsername())
                .setDisplayName(userData.getDisplayName())
                .setEmail(userData.getEmail())
                .setActive(userData.getActive())
                .setDirectory(userData.getDirectory())
                .build();
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public GroupAdministrationMappingRestDTO(@JsonProperty("entity") DirectoryEntityRestDTO entity, @JsonProperty("name") String name, @JsonProperty("displayName") String displayName, @JsonProperty("directory") DirectoryData directory, @JsonProperty("email") String email, @JsonProperty("active") Boolean active) {
        this.entity = entity;
        this.name = name;
        this.displayName = displayName;
        this.directory = directory;
        this.email = email;
        this.active = active;
    }

    public DirectoryEntityRestDTO getEntity() {
        return entity;
    }

    public String getName() {
        return name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public DirectoryData getDirectory() {
        return directory;
    }

    public String getEmail() {
        return email;
    }

    public Boolean getActive() {
        return active;
    }

    public static GroupAdministrationMappingRestDTO.Builder builder() {
        return new GroupAdministrationMappingRestDTO.Builder();
    }

    public static GroupAdministrationMappingRestDTO.Builder builder(GroupAdministrationMappingRestDTO data) {
        return new GroupAdministrationMappingRestDTO.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        GroupAdministrationMappingRestDTO that = (GroupAdministrationMappingRestDTO) o;

        return Objects.equals(this.getEntity(), that.getEntity()) &&
                Objects.equals(this.getName(), that.getName()) &&
                Objects.equals(this.getDisplayName(), that.getDisplayName()) &&
                Objects.equals(this.getDirectory(), that.getDirectory()) &&
                Objects.equals(this.getEmail(), that.getEmail()) &&
                Objects.equals(this.getActive(), that.getActive());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getEntity(), getName(), getDisplayName(), getDirectory(), getEmail(), getActive());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("entity", getEntity())
                .add("name", getName())
                .add("displayName", getDisplayName())
                .add("directory", getDirectory())
                .add("email", getEmail())
                .add("active", getActive())
                .toString();
    }

    public static final class Builder {

        private DirectoryEntityRestDTO entity;
        private String name;
        private String displayName;
        private DirectoryData directory;
        private String email;
        private Boolean active;

        private Builder() {
        }

        private Builder(GroupAdministrationMappingRestDTO initialData) {

            this.entity = initialData.getEntity();
            this.name = initialData.getName();
            this.displayName = initialData.getDisplayName();
            this.directory = initialData.getDirectory();
            this.email = initialData.getEmail();
            this.active = initialData.getActive();
        }


        public Builder setEntity(DirectoryEntityRestDTO entity) {
            this.entity = entity;
            return this;
        }


        public Builder setName(String name) {
            this.name = name;
            return this;
        }


        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }


        public Builder setDirectory(DirectoryData directory) {
            this.directory = directory;
            return this;
        }


        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }


        public Builder setActive(Boolean active) {
            this.active = active;
            return this;
        }


        public GroupAdministrationMappingRestDTO build() {
            return new GroupAdministrationMappingRestDTO(entity, name, displayName, directory, email, active);
        }
    }
}
