package com.atlassian.crowd.plugin.rest.entity.directory;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.plugin.rest.entity.admin.directory.DirectoryEntityId;
import com.atlassian.crowd.plugin.rest.entity.admin.user.UserData;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

public class DirectoryEntityRestDTO {
    @JsonProperty("id")
    private final DirectoryEntityId id;

    @JsonProperty("type")
    private final DirectoryEntityType type;

    public static DirectoryEntityRestDTO fromGroup(Group group) {
        return fromGroupName(group.getDirectoryId(), group.getName());
    }

    public static DirectoryEntityRestDTO fromUser(User user) {
        return fromUserName(user.getDirectoryId(), user.getName());
    }

    public static DirectoryEntityRestDTO fromUserData(UserData userData) {
        return new DirectoryEntityRestDTO(userData.getId(), DirectoryEntityType.USER);
    }

    public static DirectoryEntityRestDTO fromUserName(long directoryId, String userName) {
        return new DirectoryEntityRestDTO(new DirectoryEntityId(directoryId, userName), DirectoryEntityType.USER);
    }

    public static DirectoryEntityRestDTO fromGroupName(long directoryId, String groupName) {
        return new DirectoryEntityRestDTO(new DirectoryEntityId(directoryId, groupName), DirectoryEntityType.GROUP);
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public DirectoryEntityRestDTO(@JsonProperty("id") DirectoryEntityId id, @JsonProperty("type") DirectoryEntityType type) {
        this.id = id;
        this.type = type;
    }

    public DirectoryEntityId getId() {
        return id;
    }

    public DirectoryEntityType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DirectoryEntityRestDTO that = (DirectoryEntityRestDTO) o;

        return Objects.equals(this.getId(), that.getId()) &&
                Objects.equals(this.getType(), that.getType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getType());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("type", getType())
                .toString();
    }
}
