package com.atlassian.crowd.plugin.rest.entity.audit;


import com.atlassian.crowd.audit.AuditLogEntry;
import com.atlassian.crowd.audit.ImmutableAuditLogEntry;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

public class AuditLogEntryRestDTO {

    @JsonProperty("propertyName")
    private final String propertyName;

    @JsonProperty("oldValue")
    private final String oldValue;

    @JsonProperty("newValue")
    private final String newValue;

    public AuditLogEntry toEntry() {
        return new ImmutableAuditLogEntry.Builder()
                .setPropertyName(propertyName)
                .setOldValue(oldValue)
                .setNewValue(newValue)
                .build();
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public AuditLogEntryRestDTO(@JsonProperty("propertyName") String propertyName, @JsonProperty("oldValue") String oldValue, @JsonProperty("newValue") String newValue) {
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public String getOldValue() {
        return oldValue;
    }

    public String getNewValue() {
        return newValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AuditLogEntryRestDTO that = (AuditLogEntryRestDTO) o;

        return Objects.equals(this.getPropertyName(), that.getPropertyName()) &&
                Objects.equals(this.getOldValue(), that.getOldValue()) &&
                Objects.equals(this.getNewValue(), that.getNewValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getPropertyName(), getOldValue(), getNewValue());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("propertyName", getPropertyName())
                .add("oldValue", getOldValue())
                .add("newValue", getNewValue())
                .toString();
    }
}
