package com.atlassian.crowd.plugin.rest.entity.audit;

import com.atlassian.crowd.audit.AuditLogEntity;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.ImmutableAuditLogEntity;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

public class AuditLogEntityRestDTO {
    @JsonProperty("id")
    private final Long id;

    @JsonProperty("name")
    private final String name;

    @JsonProperty("displayName")
    private final String displayName;

    @JsonProperty("originalName")
    private final String originalName;

    @JsonProperty("type")
    private final AuditLogEntityType type;

    @JsonProperty("subtype")
    private final String subtype;

    @JsonProperty("primary")
    private final Boolean primary;

    public AuditLogEntity toEntity() {
        final ImmutableAuditLogEntity.Builder builder = new ImmutableAuditLogEntity.Builder()
                .setEntityId(id)
                .setEntityName(name)
                .setEntityType(type);
        if (primary != null && primary) {
            builder.setPrimary();
        }
        return builder.build();
    }

    public AuditLogEntityRestDTO(Long id, String name, String displayName, String originalName, AuditLogEntityType type, Boolean primary) {
        this(id, name, displayName, originalName, type, null, primary);
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public AuditLogEntityRestDTO(@JsonProperty("id") Long id, @JsonProperty("name") String name, @JsonProperty("displayName") String displayName, @JsonProperty("originalName") String originalName, @JsonProperty("type") AuditLogEntityType type, @JsonProperty("subtype") String subtype, @JsonProperty("primary") Boolean primary) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.originalName = originalName;
        this.type = type;
        this.subtype = subtype;
        this.primary = primary;
    }

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getOriginalName() {
        return originalName;
    }

    public AuditLogEntityType getType() {
        return type;
    }

    public String getSubtype() {
        return subtype;
    }

    public Boolean getPrimary() {
        return primary;
    }

    public static AuditLogEntityRestDTO.Builder builder() {
        return new AuditLogEntityRestDTO.Builder();
    }

    public static AuditLogEntityRestDTO.Builder builder(AuditLogEntityRestDTO data) {
        return new AuditLogEntityRestDTO.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AuditLogEntityRestDTO that = (AuditLogEntityRestDTO) o;

        return Objects.equals(this.getId(), that.getId()) &&
                Objects.equals(this.getName(), that.getName()) &&
                Objects.equals(this.getDisplayName(), that.getDisplayName()) &&
                Objects.equals(this.getOriginalName(), that.getOriginalName()) &&
                Objects.equals(this.getType(), that.getType()) &&
                Objects.equals(this.getSubtype(), that.getSubtype()) &&
                Objects.equals(this.getPrimary(), that.getPrimary());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getName(), getDisplayName(), getOriginalName(), getType(), getSubtype(), getPrimary());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("name", getName())
                .add("displayName", getDisplayName())
                .add("originalName", getOriginalName())
                .add("type", getType())
                .add("subtype", getSubtype())
                .add("primary", getPrimary())
                .toString();
    }

    public static final class Builder {

        private Long id;
        private String name;
        private String displayName;
        private String originalName;
        private AuditLogEntityType type;
        private String subtype;
        private Boolean primary;

        private Builder() {
        }

        private Builder(AuditLogEntityRestDTO initialData) {

            this.id = initialData.getId();
            this.name = initialData.getName();
            this.displayName = initialData.getDisplayName();
            this.originalName = initialData.getOriginalName();
            this.type = initialData.getType();
            this.subtype = initialData.getSubtype();
            this.primary = initialData.getPrimary();
        }


        public Builder setId(Long id) {
            this.id = id;
            return this;
        }


        public Builder setName(String name) {
            this.name = name;
            return this;
        }


        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }


        public Builder setOriginalName(String originalName) {
            this.originalName = originalName;
            return this;
        }


        public Builder setType(AuditLogEntityType type) {
            this.type = type;
            return this;
        }


        public Builder setSubtype(String subtype) {
            this.subtype = subtype;
            return this;
        }


        public Builder setPrimary(Boolean primary) {
            this.primary = primary;
            return this;
        }


        public AuditLogEntityRestDTO build() {
            return new AuditLogEntityRestDTO(id, name, displayName, originalName, type, subtype, primary);
        }
    }
}