package com.atlassian.crowd.plugin.rest.entity.audit;

import com.atlassian.crowd.audit.AuditLogAuthorType;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEventSource;
import com.atlassian.crowd.audit.AuditLogEntry;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.plugin.rest.util.ISO8601DateDeserializer;
import com.atlassian.crowd.plugin.rest.util.ISO8601DateSerializer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AuditLogChangesetRestDTO {

    @JsonProperty("id")
    private final Long id;

    @JsonProperty("timestamp")
    @JsonSerialize(using = ISO8601DateSerializer.class)
    @JsonDeserialize(using = ISO8601DateDeserializer.class)
    private final Date timestamp;

    @JsonProperty("author")
    private final AuditLogAuthorRestDTO author;

    @JsonProperty("authorType")
    @Deprecated
    private final AuditLogAuthorType authorType;

    @JsonProperty("authorId")
    @Deprecated
    private final Long authorId;

    @JsonProperty("authorName")
    @Deprecated
    private final String authorName;

    @JsonProperty("eventType")
    private final AuditLogEventType eventType;

    @JsonProperty("entityType")
    @Deprecated
    private final AuditLogEntityType entityType;

    @JsonProperty("entityId")
    @Deprecated
    private final Long entityId;

    @JsonProperty("entityName")
    @Deprecated
    private final String entityName;

    @JsonProperty("entities")
    private final Set<AuditLogEntityRestDTO> entities;

    @JsonProperty("ipAddress")
    private final String ipAddress;

    @JsonProperty("eventMessage")
    private final String eventMessage;

    @JsonProperty("source")
    private final AuditLogEventSource source;

    @JsonProperty("entries")
    private final Set<AuditLogEntryRestDTO> entries;

    public AuditLogChangeset toChangeset() {
        final AuditLogAuthorRestDTO effectiveAuthor;
        if (author == null && authorType != null) {
            effectiveAuthor = AuditLogAuthorRestDTO.builder()
                    .setType(authorType)
                    .setName(authorName)
                    .setId(authorId)
                    .build();
        } else {
            effectiveAuthor = author;
        }

        final Set<AuditLogEntityRestDTO> effectiveEntities;
        if (entities == null && entityType != null) {
            effectiveEntities = Collections.singleton(AuditLogEntityRestDTO.builder()
                    .setId(entityId)
                    .setName(entityName)
                    .setType(entityType)
                    .setPrimary(true)
                    .build());
        } else {
            effectiveEntities = entities == null ? Collections.emptySet() : entities;
        }

        Preconditions.checkArgument(effectiveAuthor != null, "Author not set");
        Preconditions.checkArgument(eventType != null, "Event type not set");
        return new ImmutableAuditLogChangeset.Builder()
                .setId(id)
                .setTimestamp(timestamp == null ? null : timestamp.toInstant())
                .setAuthor(effectiveAuthor.toAuthor())
                .setEventType(eventType)
                .setSource(source == null ? AuditLogEventSource.MANUAL : source)
                .setEntities(effectiveEntities.stream()
                        .map(AuditLogEntityRestDTO::toEntity)
                        .collect(Collectors.toList())
                )
                .setIpAddress(ipAddress)
                .setEventMessage(eventMessage)
                .setEntries(entries != null ?
                        entries.stream().map(AuditLogEntryRestDTO::toEntry).collect(Collectors.toList()) :
                        Collections.<AuditLogEntry>emptyList()
                ).build();
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public AuditLogChangesetRestDTO(@JsonProperty("id") Long id, @JsonProperty("timestamp") Date timestamp, @JsonProperty("author") AuditLogAuthorRestDTO author, @JsonProperty("authorType") AuditLogAuthorType authorType, @JsonProperty("authorId") Long authorId, @JsonProperty("authorName") String authorName, @JsonProperty("eventType") AuditLogEventType eventType, @JsonProperty("entityType") AuditLogEntityType entityType, @JsonProperty("entityId") Long entityId, @JsonProperty("entityName") String entityName, @JsonProperty("entities") Set<AuditLogEntityRestDTO> entities, @JsonProperty("ipAddress") String ipAddress, @JsonProperty("eventMessage") String eventMessage, @JsonProperty("source") AuditLogEventSource source, @JsonProperty("entries") Set<AuditLogEntryRestDTO> entries) {
        this.id = id;
        this.timestamp = timestamp;
        this.author = author;
        this.authorType = authorType;
        this.authorId = authorId;
        this.authorName = authorName;
        this.eventType = eventType;
        this.entityType = entityType;
        this.entityId = entityId;
        this.entityName = entityName;
        this.entities = entities != null ? ImmutableSet.copyOf(entities) : null;
        this.ipAddress = ipAddress;
        this.eventMessage = eventMessage;
        this.source = source;
        this.entries = entries != null ? ImmutableSet.copyOf(entries) : null;
    }

    public Long getId() {
        return id;
    }

    public Date getTimestamp() {
        return timestamp;
    }

    public AuditLogAuthorRestDTO getAuthor() {
        return author;
    }

    public AuditLogAuthorType getAuthorType() {
        return authorType;
    }

    public Long getAuthorId() {
        return authorId;
    }

    public String getAuthorName() {
        return authorName;
    }

    public AuditLogEventType getEventType() {
        return eventType;
    }

    public AuditLogEntityType getEntityType() {
        return entityType;
    }

    public Long getEntityId() {
        return entityId;
    }

    public String getEntityName() {
        return entityName;
    }

    public Set<AuditLogEntityRestDTO> getEntities() {
        return entities;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public String getEventMessage() {
        return eventMessage;
    }

    public AuditLogEventSource getSource() {
        return source;
    }

    public Set<AuditLogEntryRestDTO> getEntries() {
        return entries;
    }

    public static AuditLogChangesetRestDTO.Builder builder() {
        return new AuditLogChangesetRestDTO.Builder();
    }

    public static AuditLogChangesetRestDTO.Builder builder(AuditLogChangesetRestDTO data) {
        return new AuditLogChangesetRestDTO.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AuditLogChangesetRestDTO that = (AuditLogChangesetRestDTO) o;

        return Objects.equals(this.getId(), that.getId()) &&
                Objects.equals(this.getTimestamp(), that.getTimestamp()) &&
                Objects.equals(this.getAuthor(), that.getAuthor()) &&
                Objects.equals(this.getAuthorType(), that.getAuthorType()) &&
                Objects.equals(this.getAuthorId(), that.getAuthorId()) &&
                Objects.equals(this.getAuthorName(), that.getAuthorName()) &&
                Objects.equals(this.getEventType(), that.getEventType()) &&
                Objects.equals(this.getEntityType(), that.getEntityType()) &&
                Objects.equals(this.getEntityId(), that.getEntityId()) &&
                Objects.equals(this.getEntityName(), that.getEntityName()) &&
                Objects.equals(this.getEntities(), that.getEntities()) &&
                Objects.equals(this.getIpAddress(), that.getIpAddress()) &&
                Objects.equals(this.getEventMessage(), that.getEventMessage()) &&
                Objects.equals(this.getSource(), that.getSource()) &&
                Objects.equals(this.getEntries(), that.getEntries());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getTimestamp(), getAuthor(), getAuthorType(), getAuthorId(), getAuthorName(), getEventType(), getEntityType(), getEntityId(), getEntityName(), getEntities(), getIpAddress(), getEventMessage(), getSource(), getEntries());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("timestamp", getTimestamp())
                .add("author", getAuthor())
                .add("authorType", getAuthorType())
                .add("authorId", getAuthorId())
                .add("authorName", getAuthorName())
                .add("eventType", getEventType())
                .add("entityType", getEntityType())
                .add("entityId", getEntityId())
                .add("entityName", getEntityName())
                .add("entities", getEntities())
                .add("ipAddress", getIpAddress())
                .add("eventMessage", getEventMessage())
                .add("source", getSource())
                .add("entries", getEntries())
                .toString();
    }

    public static final class Builder {

        private Long id;
        private Date timestamp;
        private AuditLogAuthorRestDTO author;
        private AuditLogAuthorType authorType;
        private Long authorId;
        private String authorName;
        private AuditLogEventType eventType;
        private AuditLogEntityType entityType;
        private Long entityId;
        private String entityName;
        private Set<AuditLogEntityRestDTO> entities = Sets.newHashSet();
        private String ipAddress;
        private String eventMessage;
        private AuditLogEventSource source;
        private Set<AuditLogEntryRestDTO> entries = Sets.newHashSet();

        private Builder() {
        }

        private Builder(AuditLogChangesetRestDTO initialData) {

            this.id = initialData.getId();
            this.timestamp = initialData.getTimestamp();
            this.author = initialData.getAuthor();
            this.authorType = initialData.getAuthorType();
            this.authorId = initialData.getAuthorId();
            this.authorName = initialData.getAuthorName();
            this.eventType = initialData.getEventType();
            this.entityType = initialData.getEntityType();
            this.entityId = initialData.getEntityId();
            this.entityName = initialData.getEntityName();
            this.entities = Sets.newHashSet(initialData.getEntities());
            this.ipAddress = initialData.getIpAddress();
            this.eventMessage = initialData.getEventMessage();
            this.source = initialData.getSource();
            this.entries = Sets.newHashSet(initialData.getEntries());
        }


        public Builder setId(Long id) {
            this.id = id;
            return this;
        }


        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }


        public Builder setAuthor(AuditLogAuthorRestDTO author) {
            this.author = author;
            return this;
        }


        public Builder setAuthorType(AuditLogAuthorType authorType) {
            this.authorType = authorType;
            return this;
        }


        public Builder setAuthorId(Long authorId) {
            this.authorId = authorId;
            return this;
        }


        public Builder setAuthorName(String authorName) {
            this.authorName = authorName;
            return this;
        }


        public Builder setEventType(AuditLogEventType eventType) {
            this.eventType = eventType;
            return this;
        }


        public Builder setEntityType(AuditLogEntityType entityType) {
            this.entityType = entityType;
            return this;
        }


        public Builder setEntityId(Long entityId) {
            this.entityId = entityId;
            return this;
        }


        public Builder setEntityName(String entityName) {
            this.entityName = entityName;
            return this;
        }


        public Builder setEntities(Set<AuditLogEntityRestDTO> entities) {
            this.entities = entities;
            return this;
        }


        public Builder addEntity(AuditLogEntityRestDTO entity) {
            this.entities.add(entity);
            return this;
        }

        public Builder addEntities(Iterable<AuditLogEntityRestDTO> entities) {
            for (AuditLogEntityRestDTO entity : entities) {
                addEntity(entity);
            }
            return this;
        }


        public Builder setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }


        public Builder setEventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this;
        }


        public Builder setSource(AuditLogEventSource source) {
            this.source = source;
            return this;
        }


        public Builder setEntries(Set<AuditLogEntryRestDTO> entries) {
            this.entries = entries;
            return this;
        }


        public Builder addEntry(AuditLogEntryRestDTO entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder addEntries(Iterable<AuditLogEntryRestDTO> entries) {
            for (AuditLogEntryRestDTO entry : entries) {
                addEntry(entry);
            }
            return this;
        }


        public AuditLogChangesetRestDTO build() {
            return new AuditLogChangesetRestDTO(id, timestamp, author, authorType, authorId, authorName, eventType, entityType, entityId, entityName, entities, ipAddress, eventMessage, source, entries);
        }
    }
}
