package com.atlassian.crowd.plugin.rest.entity.audit;

import com.atlassian.crowd.audit.AuditLogAuthor;
import com.atlassian.crowd.audit.AuditLogAuthorType;
import com.atlassian.crowd.audit.ImmutableAuditLogAuthor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

public class AuditLogAuthorRestDTO {
    @JsonProperty("id")
    private final Long id;

    @JsonProperty("name")
    private final String name;

    @JsonProperty("displayName")
    private final String displayName;

    @JsonProperty("originalName")
    private final String originalName;

    @JsonProperty("type")
    private final AuditLogAuthorType type;

    @JsonProperty("subtype")
    private final String subtype;

    public AuditLogAuthor toAuthor() {
        Preconditions.checkState(type != null, "Author type not set");
        return new ImmutableAuditLogAuthor(id, name, type);
    }

    public AuditLogAuthorRestDTO(Long id, String name, String displayName, String originalName, AuditLogAuthorType type) {
        this(id, name, displayName, originalName, type, null);
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public AuditLogAuthorRestDTO(@JsonProperty("id") Long id, @JsonProperty("name") String name, @JsonProperty("displayName") String displayName, @JsonProperty("originalName") String originalName, @JsonProperty("type") AuditLogAuthorType type, @JsonProperty("subtype") String subtype) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.originalName = originalName;
        this.type = type;
        this.subtype = subtype;
    }

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getOriginalName() {
        return originalName;
    }

    public AuditLogAuthorType getType() {
        return type;
    }

    public String getSubtype() {
        return subtype;
    }

    public static AuditLogAuthorRestDTO.Builder builder() {
        return new AuditLogAuthorRestDTO.Builder();
    }

    public static AuditLogAuthorRestDTO.Builder builder(AuditLogAuthorRestDTO data) {
        return new AuditLogAuthorRestDTO.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AuditLogAuthorRestDTO that = (AuditLogAuthorRestDTO) o;

        return Objects.equals(this.getId(), that.getId()) &&
                Objects.equals(this.getName(), that.getName()) &&
                Objects.equals(this.getDisplayName(), that.getDisplayName()) &&
                Objects.equals(this.getOriginalName(), that.getOriginalName()) &&
                Objects.equals(this.getType(), that.getType()) &&
                Objects.equals(this.getSubtype(), that.getSubtype());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getName(), getDisplayName(), getOriginalName(), getType(), getSubtype());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("name", getName())
                .add("displayName", getDisplayName())
                .add("originalName", getOriginalName())
                .add("type", getType())
                .add("subtype", getSubtype())
                .toString();
    }

    public static final class Builder {

        private Long id;
        private String name;
        private String displayName;
        private String originalName;
        private AuditLogAuthorType type;
        private String subtype;

        private Builder() {
        }

        private Builder(AuditLogAuthorRestDTO initialData) {

            this.id = initialData.getId();
            this.name = initialData.getName();
            this.displayName = initialData.getDisplayName();
            this.originalName = initialData.getOriginalName();
            this.type = initialData.getType();
            this.subtype = initialData.getSubtype();
        }


        public Builder setId(Long id) {
            this.id = id;
            return this;
        }


        public Builder setName(String name) {
            this.name = name;
            return this;
        }


        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }


        public Builder setOriginalName(String originalName) {
            this.originalName = originalName;
            return this;
        }


        public Builder setType(AuditLogAuthorType type) {
            this.type = type;
            return this;
        }


        public Builder setSubtype(String subtype) {
            this.subtype = subtype;
            return this;
        }


        public AuditLogAuthorRestDTO build() {
            return new AuditLogAuthorRestDTO(id, name, displayName, originalName, type, subtype);
        }
    }
}