package com.atlassian.crowd.plugin.rest.entity.admin.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.plugin.rest.entity.admin.directory.DirectoryData;
import com.atlassian.crowd.plugin.rest.entity.admin.directory.DirectoryEntityId;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class UserData {
    @JsonProperty("id")
    private final DirectoryEntityId id;
    @JsonProperty("username")
    private final String username;
    @JsonProperty("displayName")
    private final String displayName;
    @JsonProperty("email")
    private final String email;
    @JsonProperty("active")
    private final Boolean active;
    @JsonProperty("directory")
    private final DirectoryData directory;
    @JsonProperty("avatarUrl")
    private final String avatarUrl;

    public static UserData fromUser(User user, Directory directory) {
        return fromUser(user, DirectoryData.fromDirectory(directory));
    }

    public static UserData fromUser(User user, DirectoryData directoryData) {
        return builderFromUser(user).setDirectory(directoryData).build();
    }

    public static UserData fromUserWithAvatarUrl(User user, DirectoryData directoryData, String avatarUrl) {
        return builderFromUser(user).setDirectory(directoryData).setAvatarUrl(avatarUrl).build();
    }

    public static UserData fromUser(User user) {
        return builderFromUser(user).build();
    }

    private static UserData.Builder builderFromUser(User user) {
        return UserData.builder()
                .setId(DirectoryEntityId.fromUser(user))
                .setUsername(user.getName())
                .setDisplayName(user.getDisplayName())
                .setEmail(user.getEmailAddress())
                .setActive(user.isActive());
    }

    public static Builder builder(DirectoryData directory, String name) {
        return UserData.builder()
                .setId(new DirectoryEntityId(directory.getId(), name))
                .setDirectory(directory)
                .setUsername(name);
    }

    public Builder toBuilder() {
        return builder(this);
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public UserData(@JsonProperty("id") DirectoryEntityId id, @JsonProperty("username") String username, @JsonProperty("displayName") String displayName, @JsonProperty("email") String email, @JsonProperty("active") Boolean active, @JsonProperty("directory") DirectoryData directory, @JsonProperty("avatarUrl") String avatarUrl) {
        this.id = id;
        this.username = username;
        this.displayName = displayName;
        this.email = email;
        this.active = active;
        this.directory = directory;
        this.avatarUrl = avatarUrl;
    }

    public DirectoryEntityId getId() {
        return id;
    }

    public String getUsername() {
        return username;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getEmail() {
        return email;
    }

    public Boolean getActive() {
        return active;
    }

    public DirectoryData getDirectory() {
        return directory;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public static UserData.Builder builder() {
        return new UserData.Builder();
    }

    public static UserData.Builder builder(UserData data) {
        return new UserData.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserData that = (UserData) o;

        return Objects.equals(this.getId(), that.getId()) &&
                Objects.equals(this.getUsername(), that.getUsername()) &&
                Objects.equals(this.getDisplayName(), that.getDisplayName()) &&
                Objects.equals(this.getEmail(), that.getEmail()) &&
                Objects.equals(this.getActive(), that.getActive()) &&
                Objects.equals(this.getDirectory(), that.getDirectory()) &&
                Objects.equals(this.getAvatarUrl(), that.getAvatarUrl());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getUsername(), getDisplayName(), getEmail(), getActive(), getDirectory(), getAvatarUrl());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("username", getUsername())
                .add("displayName", getDisplayName())
                .add("email", getEmail())
                .add("active", getActive())
                .add("directory", getDirectory())
                .add("avatarUrl", getAvatarUrl())
                .toString();
    }

    public static final class Builder {

        private DirectoryEntityId id;
        private String username;
        private String displayName;
        private String email;
        private Boolean active;
        private DirectoryData directory;
        private String avatarUrl;

        private Builder() {
        }

        private Builder(UserData initialData) {

            this.id = initialData.getId();
            this.username = initialData.getUsername();
            this.displayName = initialData.getDisplayName();
            this.email = initialData.getEmail();
            this.active = initialData.getActive();
            this.directory = initialData.getDirectory();
            this.avatarUrl = initialData.getAvatarUrl();
        }


        public Builder setId(DirectoryEntityId id) {
            this.id = id;
            return this;
        }


        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }


        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }


        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }


        public Builder setActive(Boolean active) {
            this.active = active;
            return this;
        }


        public Builder setDirectory(DirectoryData directory) {
            this.directory = directory;
            return this;
        }


        public Builder setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }


        public UserData build() {
            return new UserData(id, username, displayName, email, active, directory, avatarUrl);
        }
    }
}
