package com.atlassian.crowd.plugin.rest.entity.admin;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.token.AuthenticationToken;
import com.atlassian.crowd.plugin.rest.entity.admin.directory.DirectoryData;
import com.atlassian.crowd.plugin.rest.util.ISO8601DateDeserializer;
import com.atlassian.crowd.plugin.rest.util.ISO8601DateSerializer;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import java.util.Date;
import java.util.Objects;

@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public class UserSessionsSearchResultEntity {
    @JsonProperty("randomHash")
    private String randomHash;

    @JsonProperty("id")
    private Long id;

    @JsonProperty("initialization")
    @JsonSerialize(using = ISO8601DateSerializer.class)
    @JsonDeserialize(using = ISO8601DateDeserializer.class)
    private Date initialization;

    @JsonProperty("lastAccess")
    private Long lastAccess;

    @JsonProperty("directory")
    private DirectoryData directory;

    @JsonProperty("username")
    private String username;

    @JsonCreator
    public UserSessionsSearchResultEntity(@JsonProperty("randomHash") String randomHash,
                                          @JsonProperty("id") Long id,
                                          @JsonProperty("initialization") Date initialization,
                                          @JsonProperty("lastAccess") Long lastAccess,
                                          @JsonProperty("directory") DirectoryData directory,
                                          @JsonProperty("username") String username) {
        this.id = id;
        this.randomHash = randomHash;
        this.initialization = initialization;
        this.lastAccess = lastAccess;
        this.directory = directory;
        this.username = username;
    }

    public static UserSessionsSearchResultEntity fromToken(AuthenticationToken session, Directory directory) {
        return new UserSessionsSearchResultEntity(
                session.getRandomHash(),
                session.getId(),
                session.getCreatedDate(),
                session.getLastAccessedTime(),
                DirectoryData.fromDirectory(directory),
                session.getName()
        );
    }

    public Long getId() {
        return id;
    }

    public Date getInitialization() {
        return initialization;
    }

    public Long getLastAccess() {
        return lastAccess;
    }

    public DirectoryData getDirectory() {
        return directory;
    }

    public String getUsername() {
        return username;
    }

    public String getRandomHash() {
        return randomHash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserSessionsSearchResultEntity that = (UserSessionsSearchResultEntity) o;
        return Objects.equals(randomHash, that.randomHash) &&
                Objects.equals(id, that.id) &&
                Objects.equals(initialization, that.initialization) &&
                Objects.equals(lastAccess, that.lastAccess) &&
                Objects.equals(directory, that.directory) &&
                Objects.equals(username, that.username);
    }

    @Override
    public int hashCode() {
        return Objects.hash(randomHash, id, initialization, lastAccess, directory, username);
    }
}
