package com.atlassian.crowd.plugin.rest.entity.admin;

import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

public class FailedEntity<T> {
    @JsonProperty("entity")
    private final T entity;
    @JsonProperty("reason")
    private final String reason;

    @JsonCreator
    public FailedEntity(@JsonProperty("entity") T entity, @JsonProperty("reason") String reason) {
        this.entity = entity;
        this.reason = reason;
    }

    public T getEntity() {
        return entity;
    }

    public String getReason() {
        return reason;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FailedEntity that = (FailedEntity) o;
        return Objects.equals(entity, that.entity) &&
                Objects.equals(reason, that.reason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entity, reason);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("entity", entity)
                .add("reason", reason)
                .toString();
    }
}
