package com.atlassian.crowd.plugin.rest.entity.admin;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public class DirectoryMappingAuthenticationEntity {
    @JsonProperty("allowAll")
    private Boolean allowAll;

    @JsonProperty("allowGroups")
    private List<String> allowGroups;

    protected DirectoryMappingAuthenticationEntity() {
    }

    public DirectoryMappingAuthenticationEntity(Boolean allowAll, Collection<String> allowGroups) {
        this.allowAll = allowAll;
        this.allowGroups = null == allowGroups ? null : ImmutableList.copyOf(allowGroups);
    }

    public Boolean getAllowAll() {
        return allowAll;
    }

    public List<String> getAllowGroups() {
        return allowGroups;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("allowAll", allowAll)
                .add("allowGroups", allowGroups)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DirectoryMappingAuthenticationEntity that = (DirectoryMappingAuthenticationEntity) o;
        return Objects.equals(allowAll, that.allowAll) &&
                Objects.equals(allowGroups, that.allowGroups);
    }

    @Override
    public int hashCode() {
        return Objects.hash(allowAll, allowGroups);
    }
}