package com.atlassian.crowd.plugin.rest.entity.admin;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.token.AuthenticationToken;
import com.atlassian.crowd.plugin.rest.util.ISO8601DateDeserializer;
import com.atlassian.crowd.plugin.rest.util.ISO8601DateSerializer;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import java.util.Date;
import java.util.Objects;

@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public class ApplicationSessionsSearchResultEntity {
    @JsonProperty("randomHash")
    private String randomHash;

    @JsonProperty("id")
    private Long id;

    @JsonProperty("initialization")
    @JsonSerialize(using = ISO8601DateSerializer.class)
    @JsonDeserialize(using = ISO8601DateDeserializer.class)
    private Date initialization;

    @JsonProperty("lastAccess")
    private Long lastAccess;

    @JsonProperty("application")
    private ApplicationEntity application;

    @JsonCreator
    public ApplicationSessionsSearchResultEntity(@JsonProperty("randomHash") String randomHash,
                                                 @JsonProperty("id") Long id,
                                                 @JsonProperty("initialization") Date initialization,
                                                 @JsonProperty("lastAccess") Long lastAccess,
                                                 @JsonProperty("application") ApplicationEntity application) {
        this.randomHash = randomHash;
        this.id = id;
        this.initialization = initialization;
        this.lastAccess = lastAccess;
        this.application = application;
    }

    public static ApplicationSessionsSearchResultEntity fromToken(AuthenticationToken session, Application application) {
        return new ApplicationSessionsSearchResultEntity(
                session.getRandomHash(),
                session.getId(),
                session.getCreatedDate(),
                session.getLastAccessedTime(),
                new ApplicationEntity(
                        application.getId(),
                        application.getName(),
                        application.getDescription(),
                        application.getType(),
                        application.isActive(),
                        application.isAliasingEnabled(),
                        application.isLowerCaseOutput(),
                        application.isMembershipAggregationEnabled(),
                        application.isCachedDirectoriesAuthenticationOrderOptimisationEnabled()));
    }

    public Long getId() {
        return id;
    }

    public Date getInitialization() {
        return initialization;
    }

    public Long getLastAccess() {
        return lastAccess;
    }

    public ApplicationEntity getApplication() {
        return application;
    }

    public String getRandomHash() {
        return randomHash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApplicationSessionsSearchResultEntity that = (ApplicationSessionsSearchResultEntity) o;
        return Objects.equals(randomHash, that.randomHash) &&
                Objects.equals(id, that.id) &&
                Objects.equals(initialization, that.initialization) &&
                Objects.equals(lastAccess, that.lastAccess) &&
                Objects.equals(application, that.application);
    }

    @Override
    public int hashCode() {
        return Objects.hash(randomHash, id, initialization, lastAccess, application);
    }
}
