package com.atlassian.crowd.plugin.rest.entity;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

/**
 * Search restriction entity classes should extend this abstract class.
 *
 * SearchRestrictionEntity is an abstract class instead of an interface because JAXB doesn't play nice with interfaces.
 */
@XmlRootElement(name = "search-restriction")
@XmlSeeAlso({BooleanRestrictionEntity.class, PropertyRestrictionEntity.class, NullRestrictionEntity.class})
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "restriction-type")
@JsonSubTypes({
        @JsonSubTypes.Type(value = BooleanRestrictionEntity.class, name = "boolean-search-restriction"),
        @JsonSubTypes.Type(value = PropertyRestrictionEntity.class, name = "property-search-restriction"),
        @JsonSubTypes.Type(value = NullRestrictionEntity.class, name = "null-search-restriction")
})
public abstract class SearchRestrictionEntity {
}
