package com.atlassian.crowd.plugin.rest.entity;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;


@XmlRootElement(name = "rename")
@XmlAccessorType(XmlAccessType.FIELD)
public class RenameEntity {
    @XmlElement(name = "new-name")
    private final String newName;

    /**
     * JAXB requires a no-arg constructor.
     */
    private RenameEntity() {
        this(null);
    }

    public RenameEntity(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return newName;
    }
}
