/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBasicAuthenticationFilter
implements Filter {
    private static final String SERAPH_ALREADY_FILTERED = "os_securityfilter_already_filtered";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBasicAuthenticationFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    protected Credentials getBasicAuthCredentials(HttpServletRequest request) {
        String base64Token;
        String token;
        int delim;
        Credentials credentials = null;
        String header = request.getHeader("Authorization");
        if (header != null && header.substring(0, 5).equalsIgnoreCase("Basic") && (delim = (token = new String(Base64.decodeBase64((byte[])(base64Token = header.substring(6)).getBytes()))).indexOf(":")) != -1) {
            String name = token.substring(0, delim);
            String password = token.substring(delim + 1);
            credentials = new Credentials(name, password);
        }
        return credentials;
    }

    protected boolean isAuthenticated(HttpServletRequest request, Credentials credentials) {
        String authenticatedEntity = this.getAuthenticatedEntity(request);
        return !StringUtils.isBlank((CharSequence)authenticatedEntity) && authenticatedEntity.equals(credentials.getName());
    }

    protected void respondWithChallenge(HttpServletResponse response) throws IOException {
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "BASIC realm=\"" + this.getBasicRealm() + "\"");
        response.setHeader("Content-Type", "text/plain;charset=UTF-8");
        response.getOutputStream().write(this.getAuthenticationErrorMessage().getBytes("UTF-8"));
        response.flushBuffer();
    }

    public void destroy() {
    }

    protected void ensureSeraphForwardsRequest(ServletRequest request) {
        request.setAttribute(SERAPH_ALREADY_FILTERED, (Object)Boolean.TRUE);
    }

    protected String getAuthenticatedEntity(HttpServletRequest request) {
        Validate.notNull((Object)request);
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        Object value = session.getAttribute(this.getEntityAttributeKey());
        if (value == null || !(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    protected void setAuthenticatedEntity(HttpServletRequest request, String name) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)name);
        request.getSession().setAttribute(this.getEntityAttributeKey(), (Object)name);
    }

    protected abstract String getEntityAttributeKey();

    protected abstract String getAuthenticationErrorMessage();

    protected abstract String getBasicRealm();

    protected class Credentials {
        private final String name;
        private final String password;

        private Credentials(String name, String password) {
            this.name = name;
            this.password = password;
        }

        public String getName() {
            return this.name;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

