/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.util;

import com.atlassian.crowd.console.value.directory.ConnectorConnection;
import com.atlassian.crowd.console.value.directory.RemoteCrowdConnection;
import com.atlassian.crowd.directory.AzureAdDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.plugin.rest.entity.ApplicationEntity;
import com.atlassian.crowd.plugin.rest.entity.ApplicationEntityList;
import com.atlassian.crowd.plugin.rest.entity.AttributeEntity;
import com.atlassian.crowd.plugin.rest.entity.AttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.AzureAdConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.CrowdConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.DirectoryMappingEntity;
import com.atlassian.crowd.plugin.rest.entity.DirectoryMappingEntityList;
import com.atlassian.crowd.plugin.rest.entity.LdapConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.LdapSearchTestEntity;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntitySet;
import com.atlassian.crowd.plugin.rest.util.ApplicationLinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ApplicationEntityTranslator {
    private ApplicationEntityTranslator() {
    }

    public static Application toApplicationWithNoDirectoryMappings(ApplicationEntity applicationEntity) {
        if (applicationEntity == null) {
            return null;
        }
        ApplicationType applicationType = ApplicationEntityTranslator.toApplicationType(applicationEntity.getType());
        HashMap attributes = Maps.newHashMap();
        if (applicationEntity.getAttributes() != null) {
            for (AttributeEntity attributeEntity : applicationEntity.getAttributes()) {
                attributes.put(attributeEntity.getName(), attributeEntity.getValue());
            }
        }
        return ImmutableApplication.builder((String)applicationEntity.getName(), (ApplicationType)applicationType).setDescription(applicationEntity.getDescription()).setActive(ApplicationEntityTranslator.getBoolean(applicationEntity.isActive()).booleanValue()).setPasswordCredential(ApplicationEntityTranslator.toPasswordCredential(applicationEntity.getPassword())).setRemoteAddresses(ApplicationEntityTranslator.toRemoteAddresses(applicationEntity.getRemoteAddresses())).setLowercaseOutput(ApplicationEntityTranslator.getBoolean(applicationEntity.isLowercaseOutput()).booleanValue()).setAliasingEnabled(ApplicationEntityTranslator.getBoolean(applicationEntity.isAliasingEnabled()).booleanValue()).setAttributes((Map)attributes).build();
    }

    public static ApplicationEntity toApplicationEntity(Application application, Link link) {
        return ApplicationEntityTranslator.toApplicationEntity(application, link, PasswordMode.EXCLUDE_PASSWORD);
    }

    public static ApplicationEntity toApplicationEntity(Application application, Link link, PasswordMode passwordMode) {
        PasswordEntity passwordEntity;
        if (application == null) {
            return null;
        }
        URI applicationUri = link.getHref();
        URI passwordUri = ApplicationLinkUriHelper.buildPasswordUri(applicationUri);
        PasswordCredential credential = application.getCredential();
        switch (passwordMode) {
            case INCLUDE_PASSWORD: {
                passwordEntity = credential == null ? null : new PasswordEntity(credential.getCredential(), Link.edit((URI)passwordUri));
                break;
            }
            case EXCLUDE_PASSWORD: {
                passwordEntity = null;
                break;
            }
            default: {
                throw new AssertionError((Object)"Should not reach here");
            }
        }
        ApplicationEntity applicationEntity = new ApplicationEntity(application.getId(), application.getName(), application.getType().name(), application.getDescription(), application.isActive(), passwordEntity, application.isLowerCaseOutput(), application.isAliasingEnabled(), link);
        RemoteAddressEntitySet remoteAddressEntities = ApplicationEntityTranslator.toRemoteAddressEntities(application.getRemoteAddresses(), applicationUri);
        applicationEntity.setRemoteAddresses(remoteAddressEntities);
        AttributeEntityList attributeEntities = ApplicationEntityTranslator.toAttributeEntities(application.getAttributes());
        applicationEntity.setAttributes(attributeEntities);
        DirectoryMappingEntityList directoryMappingEntities = ApplicationEntityTranslator.toDirectoryMappingEntities(application.getDirectoryMappings(), applicationUri);
        applicationEntity.setDirectoryMappings(directoryMappingEntities);
        return applicationEntity;
    }

    public static PasswordCredential toPasswordCredential(PasswordEntity passwordEntity) {
        if (passwordEntity == null) {
            return null;
        }
        return PasswordCredential.unencrypted((String)passwordEntity.getValue());
    }

    public static List<DirectoryMapping> toDirectoryMappings(DirectoryMappingEntityList directoryMappingEntities, Application application, DirectoryManager directoryManager) throws DirectoryNotFoundException {
        if (directoryMappingEntities == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DirectoryMappingEntity directoryMappingEntity : directoryMappingEntities) {
            Directory directory = directoryManager.findDirectoryById(directoryMappingEntity.getDirectoryId().longValue());
            builder.add((Object)ApplicationEntityTranslator.toDirectoryMapping(directoryMappingEntity, application, directory));
        }
        return builder.build();
    }

    public static DirectoryMapping toDirectoryMapping(DirectoryMappingEntity directoryMappingEntity, Application application, Directory directory) {
        if (directoryMappingEntity == null) {
            return null;
        }
        return new DirectoryMapping(application, directory, directoryMappingEntity.isAuthenticateAll().booleanValue(), ApplicationEntityTranslator.toOperationTypes(directoryMappingEntity.getAllowedOperations()));
    }

    public static DirectoryMappingEntityList toDirectoryMappingEntities(List<DirectoryMapping> directoryMappings, URI applicationUri) {
        if (directoryMappings == null) {
            return null;
        }
        URI directoryMappingsUri = ApplicationLinkUriHelper.buildDirectoryMappingsUri(applicationUri);
        ArrayList directoryMappingEntities = Lists.newArrayListWithExpectedSize((int)directoryMappings.size());
        for (DirectoryMapping directoryMapping : directoryMappings) {
            DirectoryMappingEntity directoryMappingEntity = ApplicationEntityTranslator.toDirectoryMappingEntity(directoryMapping, directoryMappingsUri);
            directoryMappingEntities.add(directoryMappingEntity);
        }
        return new DirectoryMappingEntityList(directoryMappingEntities, Link.self((URI)directoryMappingsUri));
    }

    public static DirectoryMappingEntity toDirectoryMappingEntity(DirectoryMapping directoryMapping, URI directoryMappingsUri) {
        if (directoryMapping == null) {
            return null;
        }
        URI directoryMappingUri = ApplicationLinkUriHelper.buildDirectoryMappingUri(directoryMappingsUri, directoryMapping.getDirectory().getId());
        return new DirectoryMappingEntity(directoryMapping.getDirectory().getId(), directoryMapping.isAllowAllToAuthenticate(), ApplicationEntityTranslator.toOperationTypeStrings(directoryMapping.getAllowedOperations()), Link.self((URI)directoryMappingUri));
    }

    public static Set<RemoteAddress> toRemoteAddresses(RemoteAddressEntitySet remoteAddressEntities) {
        if (remoteAddressEntities == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (RemoteAddressEntity remoteAddressEntity : remoteAddressEntities) {
            builder.add((Object)ApplicationEntityTranslator.toRemoteAddress(remoteAddressEntity));
        }
        return builder.build();
    }

    public static ApplicationEntityList toApplicationEntities(Collection<Application> applications, URI baseUri) {
        URI applicationsUri = ApplicationLinkUriHelper.buildApplicationsUri(baseUri);
        ArrayList applicationEntities = Lists.newArrayListWithExpectedSize((int)applications.size());
        for (Application application : applications) {
            Link applicationLink = ApplicationLinkUriHelper.buildApplicationLink(baseUri, application.getId());
            applicationEntities.add(ApplicationEntityTranslator.toApplicationEntity(application, applicationLink));
        }
        return new ApplicationEntityList(applicationEntities, Link.self((URI)applicationsUri));
    }

    public static RemoteAddress toRemoteAddress(RemoteAddressEntity remoteAddressEntity) {
        if (remoteAddressEntity == null) {
            return null;
        }
        return new RemoteAddress(remoteAddressEntity.getValue());
    }

    public static RemoteAddressEntitySet toRemoteAddressEntities(Set<RemoteAddress> remoteAddresses, URI baseUri) {
        if (remoteAddresses == null) {
            return null;
        }
        URI remoteAddressesUri = ApplicationLinkUriHelper.buildRemoteAddressesUri(baseUri);
        Link link = Link.self((URI)remoteAddressesUri);
        HashSet remoteAddressEntities = Sets.newHashSetWithExpectedSize((int)remoteAddresses.size());
        for (RemoteAddress remoteAddress : remoteAddresses) {
            remoteAddressEntities.add(ApplicationEntityTranslator.toRemoteAddressEntity(remoteAddress, remoteAddressesUri));
        }
        return new RemoteAddressEntitySet(remoteAddressEntities, link);
    }

    public static RemoteAddressEntity toRemoteAddressEntity(RemoteAddress remoteAddress, URI baseUri) {
        if (remoteAddress == null) {
            return null;
        }
        URI uri = ApplicationLinkUriHelper.buildRemoteAddressUri(baseUri, remoteAddress.getAddress());
        Link link = Link.self((URI)uri);
        return new RemoteAddressEntity(remoteAddress.getAddress(), link);
    }

    public static Set<OperationType> toOperationTypes(Set<String> types) {
        HashSet operationTypes = Sets.newHashSetWithExpectedSize((int)types.size());
        for (String type : types) {
            operationTypes.add(ApplicationEntityTranslator.toOperationType(type));
        }
        return EnumSet.copyOf(operationTypes);
    }

    public static OperationType toOperationType(String type) {
        return OperationType.valueOf((String)type.toUpperCase());
    }

    public static Set<String> toOperationTypeStrings(Set<OperationType> types) {
        ImmutableSet.Builder operationTypesBuilder = ImmutableSet.builder();
        for (OperationType type : types) {
            operationTypesBuilder.add((Object)ApplicationEntityTranslator.toOperationTypeString(type));
        }
        return operationTypesBuilder.build();
    }

    public static String toOperationTypeString(OperationType type) {
        return type.name();
    }

    public static ApplicationType toApplicationType(String type) {
        Validate.notNull((Object)type, (String)"Application type cannot be null", (Object[])new Object[0]);
        return ApplicationType.valueOf((String)type.toUpperCase());
    }

    public static AttributeEntityList toAttributeEntities(Map<String, String> attributes) {
        if (attributes == null) {
            return null;
        }
        Set<String> keys = attributes.keySet();
        ArrayList<AttributeEntity> attributeList = new ArrayList<AttributeEntity>(keys.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributeList.add(new AttributeEntity(entry.getKey(), entry.getValue(), null));
        }
        return new AttributeEntityList(attributeList, null);
    }

    public static Boolean getBoolean(Boolean b) {
        return b != null ? b : Boolean.FALSE;
    }

    public static DirectoryImpl buildDirectoryConfiguration(LdapConnectionTestEntity connectionTestData) {
        DirectoryImpl directory = new DirectoryImpl("Name for test purposes", DirectoryType.CONNECTOR, connectionTestData.getConnector());
        directory.setActive(true);
        directory.setDescription("");
        ApplicationEntityTranslator.populateDirectoryAttributesForConnectionTest((Map<String, String>)directory.getAttributes(), connectionTestData, connectionTestData.getLdapPassword());
        new ConnectorConnection().updateDirectory(directory);
        return directory;
    }

    public static DirectoryImpl buildDirectoryConfiguration(LdapSearchTestEntity ldapSearchTestEntity) {
        DirectoryImpl directory = new DirectoryImpl("Name for test purposes", DirectoryType.CONNECTOR, (String)MoreObjects.firstNonNull((Object)ldapSearchTestEntity.getConnector(), (Object)""));
        directory.setActive(true);
        directory.setDescription("");
        Map<String, String> testAttributes = ApplicationEntityTranslator.extractDirectoryAttributesForSearchTest(ldapSearchTestEntity);
        directory.setAttributes(testAttributes);
        new ConnectorConnection().updateDirectory(directory);
        return directory;
    }

    public static DirectoryImpl buildDirectoryConfiguration(CrowdConnectionTestEntity connectionTestData) {
        DirectoryImpl directory = new DirectoryImpl("Name for test purposes", DirectoryType.CROWD, RemoteCrowdDirectory.class.getName());
        directory.setActive(true);
        directory.setDescription("");
        ApplicationEntityTranslator.populateDirectoryAttributesForConnectionTest((Map<String, String>)directory.getAttributes(), connectionTestData, connectionTestData.getApplicationPassword());
        new RemoteCrowdConnection().updateDirectory(directory);
        return directory;
    }

    public static DirectoryImpl buildDirectoryConfiguration(AzureAdConnectionTestEntity connectionTestData) {
        DirectoryImpl directory = new DirectoryImpl("Name for test purposes", DirectoryType.AZURE_AD, AzureAdDirectory.class.getName());
        directory.setActive(true);
        directory.setDescription("");
        ApplicationEntityTranslator.populateDirectoryAttributesForConnectionTest((Map<String, String>)directory.getAttributes(), connectionTestData, connectionTestData.getWebAppSecret());
        return directory;
    }

    public static void populateDirectoryAttributesForConnectionTest(Map<String, String> attributes, CrowdConnectionTestEntity connectionTestData, String password) {
        attributes.put("crowd.server.url", connectionTestData.getUrl());
        attributes.put("application.name", connectionTestData.getApplicationName());
        attributes.put("application.password", password);
        attributes.put("crowd.server.http.proxy.host", StringUtils.isBlank((CharSequence)connectionTestData.getHttpProxyHost()) ? null : connectionTestData.getHttpProxyHost());
        attributes.put("crowd.server.http.proxy.port", connectionTestData.getHttpProxyPort() == null ? null : Integer.toString(connectionTestData.getHttpProxyPort()));
        attributes.put("crowd.server.http.proxy.username", StringUtils.isBlank((CharSequence)connectionTestData.getHttpProxyUsername()) ? null : connectionTestData.getHttpProxyUsername());
        attributes.put("crowd.server.http.proxy.password", StringUtils.isBlank((CharSequence)connectionTestData.getHttpProxyPassword()) ? null : connectionTestData.getHttpProxyPassword());
    }

    public static void populateDirectoryAttributesForConnectionTest(Map<String, String> attributes, AzureAdConnectionTestEntity connectionTestData, String webAppSecret) {
        attributes.put("AZURE_AD_NATIVE_AP_IDD", connectionTestData.getNativeAppId());
        attributes.put("AZURE_AD_TENANT_ID", connectionTestData.getTenantId());
        attributes.put("AZURE_AD_WEBAPP_CLIENT_ID", connectionTestData.getWebAppId());
        attributes.put("AZURE_AD_WEBAPP_CLIENT_SECRET", webAppSecret);
        attributes.put("AZURE_AD_GRAPH_API_ENDPOINT", connectionTestData.getGraphEndpoint());
        attributes.put("AZURE_AD_AUTHORITY_API_ENDPOINT", connectionTestData.getAuthorityEndpoint());
        attributes.put("AZURE_AD_REGION", connectionTestData.getRegion());
    }

    public static Map<String, String> populateDirectoryAttributesForSearchTest(LdapSearchTestEntity configuration, Directory directory) throws DirectoryNotFoundException {
        HashMap<String, String> directoryAttributes = new HashMap<String, String>(directory.getAttributes());
        ApplicationEntityTranslator.populateCommonSearchTestAttributes(configuration, directoryAttributes);
        return directoryAttributes;
    }

    public static void populateDirectoryAttributesForConnectionTest(Map<String, String> attributes, LdapConnectionTestEntity connectionTestData, String password) {
        attributes.put("ldap.url", connectionTestData.getUrl());
        attributes.put("ldap.secure", Objects.toString(connectionTestData.getSecureMode(), null));
        attributes.put("ldap.referral", Boolean.toString(connectionTestData.getReferral()));
        attributes.put("ldap.basedn", connectionTestData.getBaseDN());
        attributes.put("ldap.userdn", connectionTestData.getUserDN());
        attributes.put("ldap.password", password);
        if (StringUtils.isNotBlank((CharSequence)connectionTestData.getUserEncryptionMethod())) {
            attributes.put("ldap.user.encryption", connectionTestData.getUserEncryptionMethod());
        }
    }

    public static Map<String, String> extractDirectoryAttributesForSearchTest(LdapSearchTestEntity searchTestEntity) {
        HashMap<String, String> directoryAttributes = new HashMap<String, String>();
        directoryAttributes.put("ldap.url", searchTestEntity.getUrl());
        directoryAttributes.put("ldap.secure", Objects.toString(searchTestEntity.getSecureMode(), null));
        directoryAttributes.put("ldap.referral", Boolean.toString(searchTestEntity.getReferral()));
        directoryAttributes.put("ldap.basedn", searchTestEntity.getBaseDN());
        directoryAttributes.put("ldap.userdn", searchTestEntity.getUserDN());
        directoryAttributes.put("ldap.password", searchTestEntity.getLdapPassword());
        if (StringUtils.isNotBlank((CharSequence)searchTestEntity.getUserEncryptionMethod())) {
            directoryAttributes.put("ldap.user.encryption", searchTestEntity.getUserEncryptionMethod());
        }
        if (searchTestEntity.getFilterExpiredUsers() != null) {
            directoryAttributes.put("ldap.filter.expiredUsers", Boolean.toString(searchTestEntity.getFilterExpiredUsers()));
        }
        if (searchTestEntity.getPrimaryGroupSupport() != null) {
            directoryAttributes.put("ldap.activedirectory.use_primary_groups", Boolean.toString(searchTestEntity.getPrimaryGroupSupport()));
        }
        directoryAttributes.put("ldap.usermembership.use", Boolean.toString(searchTestEntity.getUseUserMembershipAttribute()));
        if (searchTestEntity.getUseUserMembershipAttributeForGroupMembership() != null) {
            directoryAttributes.put("ldap.usermembership.use.for.groups", Boolean.toString(searchTestEntity.getUseUserMembershipAttributeForGroupMembership()));
        }
        ApplicationEntityTranslator.populateCommonSearchTestAttributes(searchTestEntity, directoryAttributes);
        if (searchTestEntity.getUseRelaxedDNStandardisation() != null) {
            directoryAttributes.put("ldap.relaxed.dn.standardisation", Boolean.toString(searchTestEntity.getUseRelaxedDNStandardisation()));
        }
        if (searchTestEntity.getPagedResults().booleanValue()) {
            directoryAttributes.put("ldap.pagedresults.size", String.valueOf(searchTestEntity.getPagedResultsSize()));
        }
        return directoryAttributes;
    }

    private static void populateCommonSearchTestAttributes(LdapSearchTestEntity configuration, Map<String, String> directoryAttributes) {
        directoryAttributes.put("ldap.group.dn", configuration.getGroupDNaddition());
        directoryAttributes.put("ldap.group.description", configuration.getGroupDescriptionAttr());
        directoryAttributes.put("ldap.group.name", configuration.getGroupNameAttr());
        directoryAttributes.put("ldap.group.objectclass", configuration.getGroupObjectClass());
        directoryAttributes.put("ldap.group.filter", configuration.getGroupObjectFilter());
        directoryAttributes.put("ldap.group.usernames", configuration.getGroupMemberAttr());
        directoryAttributes.put("ldap.user.dn", configuration.getUserDNaddition());
        directoryAttributes.put("ldap.user.email", configuration.getUserMailAttr());
        directoryAttributes.put("ldap.user.firstname", configuration.getUserFirstnameAttr());
        directoryAttributes.put("ldap.user.group", configuration.getUserGroupMemberAttr());
        directoryAttributes.put("ldap.user.lastname", configuration.getUserLastnameAttr());
        directoryAttributes.put("ldap.user.displayname", configuration.getUserDisplayNameAttr());
        directoryAttributes.put("ldap.user.objectclass", configuration.getUserObjectClass());
        directoryAttributes.put("ldap.user.filter", configuration.getUserObjectFilter());
        directoryAttributes.put("ldap.user.username", configuration.getUserNameAttr());
        directoryAttributes.put("ldap.user.username.rdn", configuration.getUserNameRdnAttr());
        directoryAttributes.put("ldap.user.password", configuration.getUserPasswordAttr());
        directoryAttributes.put("ldap.external.id", configuration.getUserExternalIdAttr());
    }

    public static enum PasswordMode {
        EXCLUDE_PASSWORD,
        INCLUDE_PASSWORD;

    }
}

