/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.plugins;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.plugin.rest.entity.PluginSettingEntity;
import com.atlassian.crowd.plugin.rest.response.ResponseFactory;
import com.atlassian.crowd.plugin.rest.util.SysAdminInterceptor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ExperimentalApi
@InterceptorChain(value={SysAdminInterceptor.class})
public class PluginSettingsResource {
    public static final String GLOBAL_SETTINGS_PATH = "global";
    private final PluginSettingsFactory pluginSettingsFactory;

    public PluginSettingsResource(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @POST
    @Path(value="global")
    public Response updateGlobalPluginSettings(PluginSettingEntity pluginSettingEntity) {
        this.pluginSettingsFactory.createGlobalSettings().put(pluginSettingEntity.getKey(), pluginSettingEntity.getValue());
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="global/{key}")
    public PluginSettingEntity getGlobalPluginSettings(@PathParam(value="key") String key) {
        return new PluginSettingEntity(key, this.pluginSettingsFactory.createGlobalSettings().get(key));
    }
}

