/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.permission;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.InternalApplicationHelper;
import com.atlassian.crowd.manager.application.InternalApplicationHelperImpl;
import com.atlassian.crowd.manager.permission.AnonymousUserPermissionException;
import com.atlassian.crowd.manager.permission.DirectoryGroup;
import com.atlassian.crowd.manager.permission.UserPermissionAdminService;
import com.atlassian.crowd.manager.permission.UserPermissionDowngradeException;
import com.atlassian.crowd.manager.permission.UserPermissionException;
import com.atlassian.crowd.model.page.Page;
import com.atlassian.crowd.model.permission.UserPermission;
import com.atlassian.crowd.plugin.rest.entity.RestDirectoryGroup;
import com.atlassian.crowd.plugin.rest.entity.RestPermittedGroup;
import com.atlassian.crowd.plugin.rest.entity.page.RestPage;
import com.atlassian.crowd.plugin.rest.response.ResponseFactory;
import com.atlassian.crowd.plugin.rest.util.SysAdminInterceptor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="admin")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@InterceptorChain(value={SysAdminInterceptor.class})
public class UserPermissionAdminResource {
    private static final String DEFAULT_MAX_GROUPS = "30";
    private final UserPermissionAdminService permissionAdminService;
    private final InternalApplicationHelper applicationHelper;

    public UserPermissionAdminResource(@ComponentImport UserPermissionAdminService permissionAdminService, @ComponentImport ApplicationManager applicationManager) {
        this.permissionAdminService = (UserPermissionAdminService)Preconditions.checkNotNull((Object)permissionAdminService);
        this.applicationHelper = new InternalApplicationHelperImpl((ApplicationManager)Preconditions.checkNotNull((Object)applicationManager));
    }

    @GET
    @Path(value="groups")
    public Response getDirectoryGroups(@QueryParam(value="prefix") String prefix, @QueryParam(value="start") int startIndex, @DefaultValue(value="30") @QueryParam(value="limit") int limit) throws AnonymousUserPermissionException {
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0, (Object)"'start' must be greater than or equal to 0");
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"'limit' must be greater than 0");
        boolean singleDirectoryMapping = this.isSingleDirectoryMapping();
        Page groups = StringUtils.isEmpty((CharSequence)prefix) ? this.permissionAdminService.findGroups(startIndex, limit) : this.permissionAdminService.findGroupsByPrefix(prefix, startIndex, limit);
        return ResponseFactory.ok(new RestPage(groups, directoryGroup -> new RestDirectoryGroup(directoryGroup.getGroupName(), directoryGroup.getDirectoryId(), singleDirectoryMapping ? null : directoryGroup.getDirectoryName()))).build();
    }

    @GET
    public Response getPermissions(@QueryParam(value="prefix") String prefix, @QueryParam(value="start") int startIndex, @QueryParam(value="limit") int limit) throws UserPermissionException, AnonymousUserPermissionException {
        boolean singleDirectoryMapping = this.isSingleDirectoryMapping();
        Page groups = StringUtils.isEmpty((CharSequence)prefix) ? this.permissionAdminService.findGroupsWithPermission(startIndex, limit) : this.permissionAdminService.findGroupsWithPermissionByPrefix(prefix, startIndex, limit);
        return ResponseFactory.ok(new RestPage(groups, directoryGroup -> new RestPermittedGroup(directoryGroup.getGroupName(), directoryGroup.getPermission(), directoryGroup.getDirectoryId(), singleDirectoryMapping ? null : directoryGroup.getDirectoryName()))).build();
    }

    private boolean isSingleDirectoryMapping() {
        return this.applicationHelper.findCrowdConsoleApplication().getApplicationDirectoryMappings().size() == 1;
    }

    @PUT
    public Response setPermissions(@QueryParam(value="permission") String permissionName, List<RestDirectoryGroup> groups) throws DirectoryNotFoundException, OperationFailedException, ApplicationNotFoundException, UserPermissionException, UserPermissionDowngradeException, AnonymousUserPermissionException {
        if (groups == null || groups.isEmpty()) {
            throw new IllegalArgumentException("A group must be provided to grant permissions.");
        }
        UserPermission permission = permissionName == null ? null : UserPermission.valueOf((String)permissionName);
        this.permissionAdminService.setPermissionForGroups(groups, permission);
        return ResponseFactory.noContent().build();
    }

    @POST
    @Path(value="revoke")
    public Response revokePermissions(RestDirectoryGroup group) throws DirectoryNotFoundException, OperationFailedException, ApplicationNotFoundException, UserPermissionDowngradeException, AnonymousUserPermissionException {
        if (group == null) {
            throw new IllegalArgumentException("A group must be provided to revoke permissions.");
        }
        this.permissionAdminService.revokePermissionsForGroup((DirectoryGroup)group);
        return ResponseFactory.noContent().build();
    }
}

