/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.plugin.rest.entity.AzureAdConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.CrowdConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.LdapConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.LdapSearchTestEntity;
import com.atlassian.crowd.plugin.rest.exception.DirectoryTestFailedException;
import com.atlassian.crowd.plugin.rest.exception.ValidationFailedException;
import com.atlassian.crowd.plugin.rest.util.ApplicationEntityTranslator;
import com.atlassian.crowd.search.ldap.test.LDAPConfigurationTester;
import com.atlassian.crowd.validator.DirectoryValidationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class DirectoryController {
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final DirectoryManager directoryManager;
    private final LDAPConfigurationTester ldapConfigurationTester;
    private final CrowdDirectoryService crowdDirectoryService;

    @Inject
    public DirectoryController(@ComponentImport DirectoryInstanceLoader directoryInstanceLoader, @ComponentImport DirectoryManager directoryManager, @ComponentImport LDAPConfigurationTester ldapConfigurationTester, @ComponentImport CrowdDirectoryService crowdDirectoryService) {
        this.directoryInstanceLoader = directoryInstanceLoader;
        this.directoryManager = directoryManager;
        this.ldapConfigurationTester = ldapConfigurationTester;
        this.crowdDirectoryService = crowdDirectoryService;
    }

    public void testLdapConnection(LdapConnectionTestEntity connectionTestData) throws DirectoryTestFailedException, ValidationFailedException {
        DirectoryImpl directory = ApplicationEntityTranslator.buildDirectoryConfiguration(connectionTestData);
        this.validateEntity((Directory)directory, EnumSet.of(DirectoryValidationContext.CONNECTION));
        this.testConnectionToDirectory((Directory)directory);
    }

    public void testLdapConnection(LdapConnectionTestEntity connectionTestData, Long id) throws DirectoryNotFoundException, DirectoryTestFailedException, ValidationFailedException {
        DirectoryImpl directory = new DirectoryImpl(this.directoryManager.findDirectoryById(id.longValue()));
        String password = !StringUtils.isBlank((CharSequence)connectionTestData.getUserDN()) && connectionTestData.getLdapPassword() == null ? directory.getValue("ldap.password") : connectionTestData.getLdapPassword();
        ApplicationEntityTranslator.populateDirectoryAttributesForConnectionTest((Map<String, String>)directory.getAttributes(), connectionTestData, password);
        this.validateEntity((Directory)directory, EnumSet.of(DirectoryValidationContext.CONNECTION));
        this.testConnectionToDirectory((Directory)directory);
    }

    public void testCrowdConnection(CrowdConnectionTestEntity connectionTestData) throws DirectoryTestFailedException, ValidationFailedException {
        DirectoryImpl directory = ApplicationEntityTranslator.buildDirectoryConfiguration(connectionTestData);
        this.validateEntity((Directory)directory, EnumSet.of(DirectoryValidationContext.CONNECTION));
        this.testConnectionToDirectory((Directory)directory);
    }

    public void testCrowdConnection(CrowdConnectionTestEntity connectionTestData, Long id) throws DirectoryNotFoundException, DirectoryTestFailedException, ValidationFailedException {
        DirectoryImpl directory = new DirectoryImpl(this.directoryManager.findDirectoryById(id.longValue()));
        String password = connectionTestData.getApplicationPassword() == null ? directory.getValue("application.password") : connectionTestData.getApplicationPassword();
        ApplicationEntityTranslator.populateDirectoryAttributesForConnectionTest((Map<String, String>)directory.getAttributes(), connectionTestData, password);
        this.validateEntity((Directory)directory, EnumSet.of(DirectoryValidationContext.CONNECTION));
        this.testConnectionToDirectory((Directory)directory);
    }

    public void testAzureAdConnection(AzureAdConnectionTestEntity connectionTestData) throws DirectoryTestFailedException, ValidationFailedException {
        DirectoryImpl directory = ApplicationEntityTranslator.buildDirectoryConfiguration(connectionTestData);
        this.validateEntity((Directory)directory, EnumSet.of(DirectoryValidationContext.CONNECTION));
        this.testConnectionToDirectory((Directory)directory);
    }

    public void testAzureAdConnection(AzureAdConnectionTestEntity connectionTestData, Long id) throws DirectoryNotFoundException, DirectoryTestFailedException, ValidationFailedException {
        DirectoryImpl directory = new DirectoryImpl(this.directoryManager.findDirectoryById(id.longValue()));
        String webAppSecret = connectionTestData.getWebAppSecret() == null ? directory.getValue("AZURE_AD_WEBAPP_CLIENT_SECRET") : connectionTestData.getWebAppSecret();
        ApplicationEntityTranslator.populateDirectoryAttributesForConnectionTest((Map<String, String>)directory.getAttributes(), connectionTestData, webAppSecret);
        this.validateEntity((Directory)directory, EnumSet.of(DirectoryValidationContext.CONNECTION));
        this.testConnectionToDirectory((Directory)directory);
    }

    public void testLdapSearch(LdapSearchTestEntity configuration) throws com.atlassian.crowd.exception.OperationFailedException, DirectoryTestFailedException, ValidationFailedException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)configuration.getConnector()), (Object)"Connector cannot be empty");
        Preconditions.checkArgument((configuration.getStrategy() != null ? 1 : 0) != 0, (Object)"Strategy cannot be null");
        LDAPConfigurationTester.Strategy strategy = LDAPConfigurationTester.Strategy.valueOf((String)configuration.getStrategy());
        EnumSet<DirectoryValidationContext> contexts = EnumSet.of(DirectoryValidationContext.CONNECTION, this.getDirectoryValidationContext(strategy));
        DirectoryImpl testDirectory = ApplicationEntityTranslator.buildDirectoryConfiguration(configuration);
        this.validateEntity((Directory)testDirectory, contexts);
        Map<String, String> directoryAttributes = ApplicationEntityTranslator.extractDirectoryAttributesForSearchTest(configuration);
        RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getRawDirectory(null, configuration.getConnector(), directoryAttributes);
        if (!this.ldapConfigurationTester.canFindLdapObjects(remoteDirectory, strategy)) {
            throw new DirectoryTestFailedException();
        }
    }

    public void testLdapSearch(LdapSearchTestEntity configuration, Long id) throws com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException, DirectoryTestFailedException, ValidationFailedException {
        Preconditions.checkArgument((configuration.getStrategy() != null ? 1 : 0) != 0, (Object)"Strategy cannot be null");
        LDAPConfigurationTester.Strategy strategy = LDAPConfigurationTester.Strategy.valueOf((String)configuration.getStrategy());
        DirectoryImpl testDirectory = ApplicationEntityTranslator.buildDirectoryConfiguration(configuration);
        this.validateEntity((Directory)testDirectory, EnumSet.of(this.getDirectoryValidationContext(strategy)));
        Directory directory = this.directoryManager.findDirectoryById(id.longValue());
        Map<String, String> directoryAttributes = ApplicationEntityTranslator.populateDirectoryAttributesForSearchTest(configuration, directory);
        RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getRawDirectory(id, directory.getImplementationClass(), directoryAttributes);
        if (!this.ldapConfigurationTester.canFindLdapObjects(remoteDirectory, strategy)) {
            throw new DirectoryTestFailedException();
        }
    }

    private DirectoryValidationContext getDirectoryValidationContext(LDAPConfigurationTester.Strategy strategy) {
        if (strategy == LDAPConfigurationTester.Strategy.USER) {
            return DirectoryValidationContext.USER_SEARCH;
        }
        if (strategy == LDAPConfigurationTester.Strategy.GROUP) {
            return DirectoryValidationContext.GROUP_SEARCH;
        }
        throw new IllegalArgumentException("No validation context available for given strategy: " + strategy);
    }

    private void validateEntity(Directory directory, EnumSet<DirectoryValidationContext> contexts) throws ValidationFailedException {
        List validationErrors = this.crowdDirectoryService.validateDirectoryConfiguration(directory, contexts);
        if (!validationErrors.isEmpty()) {
            throw new ValidationFailedException(validationErrors);
        }
    }

    private void testConnectionToDirectory(Directory directory) throws DirectoryTestFailedException {
        try {
            this.crowdDirectoryService.testConnection(directory);
        }
        catch (OperationFailedException e) {
            throw new DirectoryTestFailedException(e.getMessage(), e.getCause());
        }
    }
}

