/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.application;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.AliasAlreadyInUseException;
import com.atlassian.crowd.plugin.rest.service.controller.ApplicationController;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="aliases")
@AnonymousAllowed
public class AliasResource {
    private final ApplicationController applicationController;

    public AliasResource(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @GET
    @Path(value="{applicationId}/alias")
    @Produces(value={"text/plain; charset=utf-8"})
    public String getAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="user") String username) throws ApplicationNotFoundException {
        return this.applicationController.getAlias(applicationId, username);
    }

    @PUT
    @Path(value="{applicationId}/alias")
    @Consumes(value={"text/plain"})
    public Response setAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="user") String username, String alias) throws ApplicationNotFoundException, AliasAlreadyInUseException {
        this.applicationController.setAlias(applicationId, username, alias);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{applicationId}/alias")
    public Response deleteAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="user") String username) throws ApplicationNotFoundException, AliasAlreadyInUseException {
        this.applicationController.deleteAlias(applicationId, username);
        return Response.noContent().build();
    }

    @GET
    @Path(value="{applicationId}/username")
    @Produces(value={"text/plain; charset=utf-8"})
    public String getUsernameForAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="alias") String alias) throws ApplicationNotFoundException {
        return this.applicationController.getUsernameForAlias(applicationId, alias);
    }

    @GET
    @Produces(value={"application/json"})
    public Map<Long, String> getAllAliasesForUserAsJson(@QueryParam(value="user") String username) {
        return this.applicationController.getAliasesForUser(username);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response setAllAliasesForUser(@QueryParam(value="user") String username, Map<Long, String> aliasByApplication) throws AliasAlreadyInUseException {
        this.applicationController.setAliasesForUser(username, aliasByApplication);
        return Response.noContent().build();
    }

    @DELETE
    public Response deleteAllAliasesForUser(@QueryParam(value="user") String username) {
        this.applicationController.deleteAllAliasesForUser(username);
        return Response.noContent().build();
    }
}

