/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.util;

import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.Validate;

public class ApplicationLinkUriHelper {
    public static final String REMOTE_ADDRESS_QUERY_PARAM = "address";
    public static final String REMOTE_ADDRESSES_PATH_PARAM = "remote_address";
    public static final String DIRECTORY_MAPPINGS_PATH_PARAM = "directory_mapping";
    public static final String PASSWORD_PATH_PARAM = "password";

    private ApplicationLinkUriHelper() {
    }

    public static Link buildApplicationLink(URI baseUri, Long applicationId) {
        URI applicationUri = ApplicationLinkUriHelper.buildApplicationUri(baseUri, applicationId);
        return Link.self((URI)applicationUri);
    }

    public static URI buildApplicationUri(URI baseUri, Long applicationId) {
        Validate.notNull((Object)baseUri);
        Validate.notNull((Object)applicationId);
        URI applicationsUri = ApplicationLinkUriHelper.buildApplicationsUri(baseUri);
        UriBuilder builder = UriBuilder.fromUri((URI)applicationsUri);
        return builder.path("{applicationId}").build(new Object[]{applicationId});
    }

    public static URI buildApplicationsUri(URI baseUri) {
        Validate.notNull((Object)baseUri);
        UriBuilder builder = UriBuilder.fromUri((URI)baseUri);
        return builder.path("application").build(new Object[0]);
    }

    public static URI buildRemoteAddressesUri(URI applicationUri) {
        Validate.notNull((Object)applicationUri);
        UriBuilder builder = UriBuilder.fromUri((URI)applicationUri);
        return builder.path(REMOTE_ADDRESSES_PATH_PARAM).build(new Object[0]);
    }

    public static URI buildRemoteAddressUri(URI remoteAddressesUri, String remoteAddress) {
        Validate.notNull((Object)remoteAddressesUri);
        UriBuilder builder = UriBuilder.fromUri((URI)remoteAddressesUri);
        return builder.queryParam(REMOTE_ADDRESS_QUERY_PARAM, new Object[]{"{remoteAddress}"}).build(new Object[]{remoteAddress});
    }

    public static URI buildRemoteAddressUri(URI baseUri, long applicationId, String remoteAddress) {
        Validate.notNull((Object)baseUri);
        URI applicationUri = ApplicationLinkUriHelper.buildApplicationUri(baseUri, applicationId);
        URI applicationRemoteAddressesUri = ApplicationLinkUriHelper.buildRemoteAddressesUri(applicationUri);
        UriBuilder builder = UriBuilder.fromUri((URI)applicationRemoteAddressesUri);
        return builder.queryParam(REMOTE_ADDRESS_QUERY_PARAM, new Object[]{"{remoteAddress}"}).build(new Object[]{remoteAddress});
    }

    public static URI buildDirectoryMappingsUri(URI applicationUri) {
        Validate.notNull((Object)applicationUri);
        UriBuilder builder = UriBuilder.fromUri((URI)applicationUri);
        return builder.path(DIRECTORY_MAPPINGS_PATH_PARAM).build(new Object[0]);
    }

    public static URI buildDirectoryMappingUri(URI directoryMappingsUri, long directoryId) {
        Validate.notNull((Object)directoryMappingsUri);
        UriBuilder builder = UriBuilder.fromUri((URI)directoryMappingsUri);
        return builder.path(String.valueOf(directoryId)).build(new Object[0]);
    }

    public static URI buildPasswordUri(URI applicationUri) {
        Validate.notNull((Object)applicationUri);
        return UriBuilder.fromUri((URI)applicationUri).path(PASSWORD_PATH_PARAM).build(new Object[0]);
    }
}

