/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.AttributeValuesHolder;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.service.client.AbstractClientProperties;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.crowd.service.factory.CrowdClientFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCrowdDirectory
implements RemoteDirectory {
    public static final String DESCRIPTIVE_NAME = "Remote Crowd Directory";
    public static final String APPLICATION_NAME = "application.name";
    public static final String APPLICATION_PASSWORD = "application.password";
    public static final String CROWD_SERVER_URL = "crowd.server.url";
    public static final String CROWD_HTTP_TIMEOUT = "crowd.server.http.timeout";
    public static final String CROWD_HTTP_MAX_CONNECTIONS = "crowd.server.http.max.connections";
    public static final String CROWD_HTTP_PROXY_HOST = "crowd.server.http.proxy.host";
    public static final String CROWD_HTTP_PROXY_PORT = "crowd.server.http.proxy.port";
    public static final String CROWD_HTTP_PROXY_USERNAME = "crowd.server.http.proxy.username";
    public static final String CROWD_HTTP_PROXY_PASSWORD = "crowd.server.http.proxy.password";
    public static final long DEFAULT_POLLING_INTERVAL_SECONDS = 60L;
    public static final long DEFAULT_HTTP_TIMEOUT_SECONDS = 5L;
    public static final long DEFAULT_HTTP_MAX_CONNECTIONS = 20L;
    private final CrowdClientFactory crowdClientFactory;
    private long directoryId;
    protected AttributeValuesHolder attributes;
    private CrowdClient crowdClient;

    public RemoteCrowdDirectory(CrowdClientFactory crowdClientFactory) {
        this.crowdClientFactory = crowdClientFactory;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(long directoryId) {
        this.directoryId = directoryId;
    }

    public com.atlassian.crowd.model.user.User findUserByName(String name) throws UserNotFoundException, OperationFailedException {
        try {
            return this.buildUserWithDirectoryId(this.crowdClient.getUser(name));
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException, OperationFailedException {
        try {
            return this.buildUserWithDirectoryId(this.crowdClient.getUserWithAttributes(name));
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public com.atlassian.crowd.model.user.User authenticate(String username, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        try {
            return this.buildUserWithDirectoryId(this.crowdClient.authenticateUser(username, credential.getCredential()));
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public com.atlassian.crowd.model.user.User addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, OperationFailedException {
        Validate.notNull((Object)user, (String)"user cannot be null");
        Validate.notNull((Object)user.getName(), (String)"user.name cannot be null");
        UserTemplate userTemplate = new UserTemplate((com.atlassian.crowd.model.user.User)user);
        userTemplate.setDirectoryId(-1L);
        try {
            this.crowdClient.addUser((com.atlassian.crowd.model.user.User)userTemplate, credential);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        try {
            return this.findUserByName(user.getName());
        }
        catch (UserNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public com.atlassian.crowd.model.user.User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException, OperationFailedException {
        Validate.notNull((Object)user, (String)"user cannot be null");
        Validate.notNull((Object)user.getName(), (String)"user.name cannot be null");
        UserTemplate userTemplate = new UserTemplate((com.atlassian.crowd.model.user.User)user);
        userTemplate.setDirectoryId(-1L);
        try {
            this.crowdClient.updateUser((com.atlassian.crowd.model.user.User)userTemplate);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        return this.findUserByName(user.getName());
    }

    public void updateUserCredential(String username, PasswordCredential credential) throws UserNotFoundException, InvalidCredentialException, OperationFailedException {
        try {
            this.crowdClient.updateUserCredential(username, credential.getCredential());
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public com.atlassian.crowd.model.user.User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException {
        throw new UnsupportedOperationException("Renaming of users is not supported");
    }

    public void storeUserAttributes(String username, Map<String, Set<String>> attributes) throws UserNotFoundException, OperationFailedException {
        try {
            this.crowdClient.storeUserAttributes(username, attributes);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void removeUserAttributes(String username, String attributeName) throws UserNotFoundException, OperationFailedException {
        try {
            this.crowdClient.removeUserAttributes(username, attributeName);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void removeUser(String username) throws UserNotFoundException, OperationFailedException {
        try {
            this.crowdClient.removeUser(username);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public <T> List<T> searchUsers(EntityQuery<T> query) throws OperationFailedException {
        if (query.getEntityDescriptor().getEntityType() != Entity.USER) {
            throw new IllegalArgumentException("Query is not a user query.");
        }
        try {
            Class returnType = query.getReturnType();
            if (String.class.equals((Object)returnType)) {
                return this.crowdClient.searchUserNames(query.getSearchRestriction(), query.getStartIndex(), query.getMaxResults());
            }
            if (User.class.isAssignableFrom(returnType)) {
                List users = this.crowdClient.searchUsers(query.getSearchRestriction(), query.getStartIndex(), query.getMaxResults());
                return this.buildUserListWithDirectoryId(users);
            }
            throw new IllegalArgumentException("Unknown return type for query: " + returnType.getName());
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public com.atlassian.crowd.model.group.Group findGroupByName(String name) throws GroupNotFoundException, OperationFailedException {
        try {
            return this.buildGroupWithDirectoryId(this.crowdClient.getGroup(name));
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException, OperationFailedException {
        try {
            return this.buildGroupWithDirectoryId(this.crowdClient.getGroupWithAttributes(name));
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public com.atlassian.crowd.model.group.Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        Validate.notNull((Object)group, (String)"group cannot be null");
        Validate.notNull((Object)group.getName(), (String)"group.name cannot be null");
        GroupTemplate groupTemplate = new GroupTemplate((com.atlassian.crowd.model.group.Group)group);
        groupTemplate.setDirectoryId(-1L);
        try {
            this.crowdClient.addGroup((com.atlassian.crowd.model.group.Group)groupTemplate);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        try {
            return this.findGroupByName(group.getName());
        }
        catch (GroupNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public com.atlassian.crowd.model.group.Group updateGroup(GroupTemplate group) throws InvalidGroupException, GroupNotFoundException, OperationFailedException {
        Validate.notNull((Object)group, (String)"group cannot be null");
        Validate.notNull((Object)group.getName(), (String)"group.name cannot be null");
        GroupTemplate groupTemplate = new GroupTemplate((com.atlassian.crowd.model.group.Group)group);
        groupTemplate.setDirectoryId(-1L);
        try {
            this.crowdClient.updateGroup((com.atlassian.crowd.model.group.Group)groupTemplate);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        return this.findGroupByName(group.getName());
    }

    public com.atlassian.crowd.model.group.Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException {
        throw new UnsupportedOperationException("Renaming of groups is not supported");
    }

    public void storeGroupAttributes(String groupName, Map<String, Set<String>> attributes) throws GroupNotFoundException, OperationFailedException {
        try {
            this.crowdClient.storeGroupAttributes(groupName, attributes);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws GroupNotFoundException, OperationFailedException {
        try {
            this.crowdClient.removeGroupAttributes(groupName, attributeName);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void removeGroup(String groupname) throws GroupNotFoundException, OperationFailedException {
        try {
            this.crowdClient.removeGroup(groupname);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public <T> List<T> searchGroups(EntityQuery<T> query) throws OperationFailedException {
        if (query.getEntityDescriptor().getEntityType() != Entity.GROUP) {
            throw new IllegalArgumentException("Query is not a group query.");
        }
        try {
            Class returnType = query.getReturnType();
            if (String.class.isAssignableFrom(returnType)) {
                return this.crowdClient.searchGroupNames(query.getSearchRestriction(), query.getStartIndex(), query.getMaxResults());
            }
            if (com.atlassian.crowd.model.group.Group.class.isAssignableFrom(returnType) || Group.class.isAssignableFrom(returnType)) {
                List groups = this.crowdClient.searchGroups(query.getSearchRestriction(), query.getStartIndex(), query.getMaxResults());
                return this.buildGroupListWithDirectoryId(groups);
            }
            throw new IllegalArgumentException("Unknown return type for query: " + returnType.getName());
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public boolean isUserDirectGroupMember(String username, String groupName) throws OperationFailedException {
        try {
            return this.crowdClient.isUserDirectGroupMember(username, groupName);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) throws OperationFailedException {
        try {
            return this.crowdClient.isGroupDirectGroupMember(childGroup, parentGroup);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void addUserToGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, OperationFailedException {
        try {
            this.crowdClient.addUserToGroup(username, groupName);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, OperationFailedException {
        try {
            this.crowdClient.addGroupToGroup(childGroup, parentGroup);
        }
        catch (UserNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void removeUserFromGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, MembershipNotFoundException, OperationFailedException {
        try {
            this.crowdClient.removeUserFromGroup(username, groupName);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, MembershipNotFoundException, OperationFailedException {
        try {
            this.crowdClient.removeGroupFromGroup(childGroup, parentGroup);
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public <T> List<T> searchGroupRelationships(MembershipQuery<T> query) throws OperationFailedException {
        try {
            if (query.isFindChildren()) {
                if (query.getEntityToReturn().getEntityType() == Entity.USER) {
                    if (query.getReturnType() == String.class) {
                        return this.crowdClient.getNamesOfUsersOfGroup(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                    }
                    List users = this.crowdClient.getUsersOfGroup(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                    return this.buildUserListWithDirectoryId(users);
                }
                if (query.getEntityToReturn().getEntityType() == Entity.GROUP) {
                    if (query.getReturnType() == String.class) {
                        return this.crowdClient.getNamesOfChildGroupsOfGroup(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                    }
                    List groups = this.crowdClient.getChildGroupsOfGroup(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                    return this.buildGroupListWithDirectoryId(groups);
                }
                throw new IllegalArgumentException("Query is not a group or user membership query.");
            }
            if (query.getEntityToMatch().getEntityType() == Entity.USER) {
                if (query.getReturnType() == String.class) {
                    return this.crowdClient.getNamesOfGroupsForUser(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                }
                List groups = this.crowdClient.getGroupsForUser(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                return this.buildGroupListWithDirectoryId(groups);
            }
            if (query.getEntityToReturn().getEntityType() == Entity.GROUP) {
                if (query.getReturnType() == String.class) {
                    return this.crowdClient.getNamesOfParentGroupsForGroup(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                }
                List groups = this.crowdClient.getParentGroupsForGroup(query.getEntityNameToMatch(), query.getStartIndex(), query.getMaxResults());
                return this.buildGroupListWithDirectoryId(groups);
            }
            throw new IllegalArgumentException("Query is not a group or user membership query.");
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (UserNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public void testConnection() throws OperationFailedException {
        try {
            this.crowdClient.testConnection();
        }
        catch (InvalidAuthenticationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean supportsInactiveAccounts() {
        return true;
    }

    public boolean supportsNestedGroups() {
        return this.attributes.getAttributeAsBoolean("useNestedGroups", false);
    }

    public boolean isRolesDisabled() {
        return false;
    }

    public String getDescriptiveName() {
        return DESCRIPTIVE_NAME;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = new AttributeValuesHolder(attributes);
        this.createCrowdClient();
    }

    public Set<String> getValues(String name) {
        return this.attributes.getValues(name);
    }

    public String getValue(String name) {
        return this.attributes.getValue(name);
    }

    private String getValue(String name, String defaultValue) {
        String val = this.attributes.getValue(name);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public Set<String> getKeys() {
        return this.attributes.getKeys();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    private void createCrowdClient() {
        RemoteCrowdsClientProperties clientProperties = new RemoteCrowdsClientProperties(this.getValue(CROWD_SERVER_URL), this.getValue(APPLICATION_NAME), this.getValue(APPLICATION_PASSWORD), this.getValue(CROWD_HTTP_TIMEOUT, Long.toString(5000L)), this.getValue(CROWD_HTTP_MAX_CONNECTIONS, Long.toString(20L)), this.getValue(CROWD_HTTP_PROXY_HOST), this.getValue(CROWD_HTTP_PROXY_PORT), this.getValue(CROWD_HTTP_PROXY_USERNAME), this.getValue(CROWD_HTTP_PROXY_PASSWORD));
        this.crowdClient = this.crowdClientFactory.newInstance((ClientProperties)clientProperties);
    }

    private <T extends com.atlassian.crowd.model.user.User> T buildUserWithDirectoryId(T user) {
        UserTemplateWithAttributes userTemplateWithAttributes = user instanceof UserWithAttributes ? new UserTemplateWithAttributes((UserWithAttributes)user) : UserTemplateWithAttributes.ofUserWithNoAttributes(user);
        userTemplateWithAttributes.setDirectoryId(this.directoryId);
        return (T)userTemplateWithAttributes;
    }

    private <T extends com.atlassian.crowd.model.user.User> List<T> buildUserListWithDirectoryId(List<T> users) {
        ArrayList<com.atlassian.crowd.model.user.User> newUsers = new ArrayList<com.atlassian.crowd.model.user.User>();
        for (com.atlassian.crowd.model.user.User user : users) {
            newUsers.add(this.buildUserWithDirectoryId(user));
        }
        return newUsers;
    }

    private <T extends com.atlassian.crowd.model.group.Group> T buildGroupWithDirectoryId(T group) {
        GroupTemplateWithAttributes groupTemplateWithAttributes = group instanceof GroupWithAttributes ? new GroupTemplateWithAttributes((GroupWithAttributes)group) : GroupTemplateWithAttributes.ofGroupWithNoAttributes(group);
        groupTemplateWithAttributes.setDirectoryId(this.directoryId);
        return (T)groupTemplateWithAttributes;
    }

    private <T extends com.atlassian.crowd.model.group.Group> List<T> buildGroupListWithDirectoryId(List<T> groups) {
        ArrayList<com.atlassian.crowd.model.group.Group> newGroups = new ArrayList<com.atlassian.crowd.model.group.Group>();
        for (com.atlassian.crowd.model.group.Group group : groups) {
            newGroups.add(this.buildGroupWithDirectoryId(group));
        }
        return newGroups;
    }

    private static class RemoteCrowdsClientProperties
    extends AbstractClientProperties {
        private RemoteCrowdsClientProperties(String url, String username, String password, String httpTimeOut, String httpMaxConnections, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword) {
            this.baseURL = url;
            this.applicationName = username;
            this.applicationPassword = password;
            this.httpTimeout = httpTimeOut;
            this.httpMaxConnections = httpMaxConnections;
            this.httpProxyHost = proxyHost;
            this.httpProxyPort = proxyPort;
            this.httpProxyPassword = proxyUsername;
            this.httpProxyPassword = proxyPassword;
        }

        public void updateProperties(Properties properties) {
            throw new UnsupportedOperationException("not supported");
        }
    }
}

