/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.descriptors;

import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.plugin.PluginUtils;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordEncoderModuleDescriptor
extends AbstractModuleDescriptor<PasswordEncoder>
implements ApplicationContextAware,
StateAware {
    private static final Logger log = Logger.getLogger(PasswordEncoderModuleDescriptor.class);
    private PasswordEncoder passwordEncoder;
    private PasswordEncoderFactory passwordEncoderFactory;
    private ApplicationContext applicationContext;

    public PasswordEncoder getModule() {
        if (this.passwordEncoder == null) {
            this.passwordEncoder = (PasswordEncoder)PluginUtils.instantiateModule(this.plugin, this.getModuleClass(), this.applicationContext);
        }
        return this.passwordEncoder;
    }

    private void discardModuleReference() {
        this.passwordEncoder = null;
    }

    public void enabled() {
        super.enabled();
        PasswordEncoder passwordEncoder = this.getModule();
        if (passwordEncoder instanceof StateAware) {
            StateAware stateAware = (StateAware)passwordEncoder;
            stateAware.enabled();
        }
        this.passwordEncoderFactory.addEncoder(passwordEncoder);
    }

    public void disabled() {
        this.passwordEncoderFactory.removeEncoder(this.getModule());
        this.discardModuleReference();
        super.disabled();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setPasswordEncoderFactory(PasswordEncoderFactory passwordEncoderFactory) {
        this.passwordEncoderFactory = passwordEncoderFactory;
    }
}

