/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin;

import com.atlassian.config.HomeLocator;
import com.atlassian.crowd.plugin.descriptors.webwork.PluginAwareObjectFactory;
import com.atlassian.crowd.plugin.descriptors.webwork.PluginClassTemplateLoader;
import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.Plugin;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.xwork.ObjectFactory;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUtils {
    private static final Logger log = Logger.getLogger(PluginUtils.class);
    public static final String CROWD_APPLICATION_KEY = "crowd";
    public static final String PLUGIN_DESCRIPTOR_FILENAME = "atlassian-plugin.xml";

    public static void initialiseWebworkForPluginSupport(ServletContext servletContext) {
        PluginAwareObjectFactory objectFactory = new PluginAwareObjectFactory();
        objectFactory.init(servletContext);
        ObjectFactory.setObjectFactory((ObjectFactory)objectFactory);
        try {
            Configuration fmConfig = FreemarkerManager.getInstance().getConfiguration(servletContext);
            MultiTemplateLoader loader = new MultiTemplateLoader(new TemplateLoader[]{fmConfig.getTemplateLoader(), new PluginClassTemplateLoader()});
            fmConfig.setTemplateLoader((TemplateLoader)loader);
        }
        catch (TemplateException e) {
            log.error((Object)("Error updating Freemarker configuration. WebWork plugins may have issues rendering Freemarker results." + e.getMessage()), (Throwable)e);
        }
    }

    public static <T> T instantiateModule(Plugin plugin, Class<T> moduleClass, ApplicationContext applicationContext) {
        if (plugin instanceof AutowireCapablePlugin) {
            return (T)((AutowireCapablePlugin)plugin).autowire(moduleClass);
        }
        try {
            T listenerObject = moduleClass.newInstance();
            applicationContext.getAutowireCapableBeanFactory().autowireBeanProperties(listenerObject, 1, false);
            return listenerObject;
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage());
        }
        return null;
    }

    public static File getHomeSubDirectory(HomeLocator homeLocator, String subDirectory) {
        File homePath = new File(homeLocator.getHomePath());
        File directory = new File(homePath, subDirectory);
        if (!directory.exists()) {
            directory.mkdir();
        }
        return directory;
    }
}

