/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin;

import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.crowd.plugin.PluginDirectoryLocator;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class CrowdPluginManager
extends DefaultPluginManager
implements ApplicationListener,
PluginController,
PluginAccessor {
    private static final Logger log = Logger.getLogger(CrowdPluginManager.class);
    private boolean initialised = false;

    public CrowdPluginManager(PluginPersistentStateStore pluginStateStore, List pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, HostContainer hostContainer, PluginDirectoryLocator pluginDirectoryLocator) {
        super(pluginStateStore, CrowdPluginManager.replaceStringsWithPluginLoaders(pluginLoaders), moduleDescriptorFactory, pluginEventManager);
        FilePluginInstaller installer = new FilePluginInstaller(pluginDirectoryLocator.getPluginsDirectory());
        this.setPluginInstaller((PluginInstaller)installer);
    }

    private static List replaceStringsWithPluginLoaders(List list) {
        ListIterator<SinglePluginLoader> it = list.listIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof String)) continue;
            it.remove();
            it.add(new SinglePluginLoader((String)o));
        }
        return list;
    }

    public void init() throws PluginParseException {
        if (this.initialised) {
            log.error((Object)"Init() called on an already initialised plugin manager. Ignoring.");
            return;
        }
        super.init();
        this.initialised = true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartedEvent) {
            try {
                this.init();
            }
            catch (PluginParseException e) {
                throw new RuntimeException("Error initialising plugin manager: " + e.getMessage(), e);
            }
        }
    }
}

