/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.password.constraint;

import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.ValidatePasswordRequest;

public class PasswordLengthConstraint
implements PasswordConstraint {
    private final int minimumLength;

    public PasswordLengthConstraint(int minimumLength) {
        if (minimumLength < 0) {
            throw new IllegalArgumentException("minimumLength must be at least zero");
        }
        this.minimumLength = minimumLength;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public String toString() {
        return "PasswordLengthConstraint(minimum=" + this.minimumLength + ")";
    }

    public boolean validate(ValidatePasswordRequest request) {
        return request.getPassword().getCredential().length() >= this.minimumLength;
    }
}

