/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.InternalDirectoryUtils;
import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.ValidatePasswordRequest;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class InternalDirectoryUtilsImpl
implements InternalDirectoryUtils {
    @Override
    public void validateDirectoryForEntity(DirectoryEntity entity, Long directoryId) {
        Validate.notNull((Object)entity, (String)"entity cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getDirectoryId(), (String)"directoryId of entity cannot be null", (Object[])new Object[0]);
        Validate.isTrue((entity.getDirectoryId() == directoryId.longValue() ? 1 : 0) != 0, (String)"directoryId does not match the directoryId of the InternalDirectory", (Object[])new Object[0]);
    }

    @Override
    public void validateUsername(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("A username must not be null or empty or blank");
        }
    }

    @Override
    public void validateCredential(User user, PasswordCredential credential, Set<PasswordConstraint> passwordConstraints, @Nullable String passwordComplexityMessage) throws InvalidCredentialException {
        if (user == null) {
            throw new NullPointerException("user cannot be null");
        }
        if (credential == null) {
            throw new NullPointerException("credential cannot be null");
        }
        if (!credential.isEncryptedCredential()) {
            if (StringUtils.isBlank((CharSequence)credential.getCredential())) {
                throw new InvalidCredentialException("You cannot have an empty password");
            }
            Collection failedConstraints = passwordConstraints.stream().filter(InternalDirectoryUtilsImpl.validationFailed(user, credential)).collect(Collectors.toSet());
            if (!failedConstraints.isEmpty()) {
                throw new InvalidCredentialException(StringUtils.stripToNull((String)passwordComplexityMessage), failedConstraints);
            }
        }
    }

    @Override
    public void validateGroupName(Group group, String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            throw new IllegalArgumentException("A group name must not be null or empty or blank");
        }
    }

    private static Predicate<PasswordConstraint> validationFailed(User user, PasswordCredential password) {
        return constraint -> !constraint.validate(new ValidatePasswordRequest(password, user));
    }
}

