package com.atlassian.crowd.model.tombstone;

/**
 * Parent class for events related to specific applications, such as configuration changes and aliasing changes.
 */
public abstract class ApplicationTombstone extends AbstractTombstone {
    protected long applicationId;

    protected ApplicationTombstone() {
    }

    public ApplicationTombstone(long timestamp, long applicationId) {
        super(timestamp);
        this.applicationId = applicationId;
    }

    public long getApplicationId() {
        return applicationId;
    }

    protected void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }
}
