package com.atlassian.crowd.model.sso.idp;

import java.util.Objects;

public class SAMLTrustEntity {
    private Long id;
    private PemCertificate pemCertificate;
    private PemPrivateKey pemPrivateKey;

    public SAMLTrustEntity() {
    }

    public SAMLTrustEntity(PemCertificate pemCertificate, PemPrivateKey pemPrivateKey) {
        this.pemCertificate = pemCertificate;
        this.pemPrivateKey = pemPrivateKey;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PemCertificate getPemCertificate() {
        return pemCertificate;
    }

    public void setPemCertificate(PemCertificate pemCertificate) {
        this.pemCertificate = pemCertificate;
    }

    public PemPrivateKey getPemPrivateKey() {
        return pemPrivateKey;
    }

    public void setPemPrivateKey(PemPrivateKey pemPrivateKey) {
        this.pemPrivateKey = pemPrivateKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SAMLTrustEntity that = (SAMLTrustEntity) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(pemCertificate, that.pemCertificate) &&
                Objects.equals(pemPrivateKey, that.pemPrivateKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, pemCertificate, pemPrivateKey);
    }

    @Override
    public String toString() {
        return "SAMLTrustEntity{" +
                "id=" + id +
                ", pemCertificate=" + pemCertificate +
                ", pemPrivateKey=" + pemPrivateKey +
                '}';
    }
}
