package com.atlassian.crowd.model.sso.idp;

import java.util.Date;
import java.util.Objects;

public class PemCertificate {
    private String pemCertificate;
    private Date createdDate;
    private Date expirationDate;

    public PemCertificate() {
    }

    public PemCertificate(String pemCertificate, Date createdDate, Date expirationDate) {
        this.pemCertificate = pemCertificate;
        this.createdDate = createdDate;
        this.expirationDate = expirationDate;
    }

    public String getPemCertificate() {
        return pemCertificate;
    }

    public void setPemCertificate(String pemCertificate) {
        this.pemCertificate = pemCertificate;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PemCertificate that = (PemCertificate) o;
        return Objects.equals(pemCertificate, that.pemCertificate) &&
                Objects.equals(createdDate, that.createdDate) &&
                Objects.equals(expirationDate, that.expirationDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pemCertificate, createdDate, expirationDate);
    }

    @Override
    public String toString() {
        return "PemCertificate{" +
                "pemCertificate='" + pemCertificate + '\'' +
                ", createdDate=" + createdDate +
                ", expirationDate=" + expirationDate +
                '}';
    }
}
