package com.atlassian.crowd.model.rememberme;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

import javax.annotation.Nonnull;
import java.time.LocalDateTime;
import java.util.Objects;

public class InternalCrowdRememberMeToken implements CrowdRememberMeToken {

    private Long id;

    @Nonnull
    private String token;

    @Nonnull
    private String username;

    @Nonnull
    private Long directoryId;

    @Nonnull
    private LocalDateTime createdTime;

    private LocalDateTime usedTime;

    @Nonnull
    private String series;

    private String remoteAddress;

    public InternalCrowdRememberMeToken() {
    }

    public InternalCrowdRememberMeToken(Long id, String token, String username, Long directoryId, LocalDateTime createdTime,
                                        LocalDateTime usedTime, String series, String remoteAddress) {
        this.id = id;
        this.token = Preconditions.checkNotNull(token);
        this.username = username;
        this.directoryId = directoryId;
        this.createdTime = createdTime;
        this.usedTime = usedTime;
        this.series = Preconditions.checkNotNull(series);
        this.remoteAddress = remoteAddress;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setToken(@Nonnull String token) {
        this.token = token;
    }

    public void setDirectoryId(@Nonnull Long directoryId) {
        this.directoryId = directoryId;
    }

    public void setUsedTime(LocalDateTime usedTime) {
        this.usedTime = usedTime;
    }

    public void setCreatedTime(@Nonnull LocalDateTime createdTime) {
        this.createdTime = createdTime;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setSeries(@Nonnull String series) {
        this.series = series;
    }

    public void setUsername(@Nonnull String username) {
        this.username = username;
    }

    public Long getId() {
        return id;
    }

    public String getToken() {
        return token;
    }

    public String getUsername() {
        return username;
    }

    public Long getDirectoryId() {
        return directoryId;
    }

    public LocalDateTime getCreatedTime() {
        return createdTime;
    }

    public LocalDateTime getUsedTime() {
        return usedTime;
    }

    public String getSeries() {
        return series;
    }

    public String getRemoteAddress() {
        return remoteAddress;
    }

    public static InternalCrowdRememberMeToken.Builder builder() {
        return new InternalCrowdRememberMeToken.Builder();
    }

    public static InternalCrowdRememberMeToken.Builder builder(InternalCrowdRememberMeToken data) {
        return new InternalCrowdRememberMeToken.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        InternalCrowdRememberMeToken that = (InternalCrowdRememberMeToken) o;

        return Objects.equals(this.getId(), that.getId()) &&
                Objects.equals(this.getToken(), that.getToken()) &&
                Objects.equals(this.getUsername(), that.getUsername()) &&
                Objects.equals(this.getDirectoryId(), that.getDirectoryId()) &&
                Objects.equals(this.getCreatedTime(), that.getCreatedTime()) &&
                Objects.equals(this.getUsedTime(), that.getUsedTime()) &&
                Objects.equals(this.getSeries(), that.getSeries()) &&
                Objects.equals(this.getRemoteAddress(), that.getRemoteAddress());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getToken(), getUsername(), getDirectoryId(), getCreatedTime(), getUsedTime(), getSeries(), getRemoteAddress());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("token", getToken())
                .add("username", getUsername())
                .add("directoryId", getDirectoryId())
                .add("createdTime", getCreatedTime())
                .add("usedTime", getUsedTime())
                .add("series", getSeries())
                .add("remoteAddress", getRemoteAddress())
                .toString();
    }

    public static final class Builder {

        private Long id;
        private String token;
        private String username;
        private Long directoryId;
        private LocalDateTime createdTime;
        private LocalDateTime usedTime;
        private String series;
        private String remoteAddress;

        private Builder() {
        }

        private Builder(InternalCrowdRememberMeToken initialData) {

            this.id = initialData.getId();
            this.token = initialData.getToken();
            this.username = initialData.getUsername();
            this.directoryId = initialData.getDirectoryId();
            this.createdTime = initialData.getCreatedTime();
            this.usedTime = initialData.getUsedTime();
            this.series = initialData.getSeries();
            this.remoteAddress = initialData.getRemoteAddress();
        }


        public Builder setId(Long id) {
            this.id = id;
            return this;
        }


        public Builder setToken(String token) {
            this.token = token;
            return this;
        }


        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }


        public Builder setDirectoryId(Long directoryId) {
            this.directoryId = directoryId;
            return this;
        }


        public Builder setCreatedTime(LocalDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }


        public Builder setUsedTime(LocalDateTime usedTime) {
            this.usedTime = usedTime;
            return this;
        }


        public Builder setSeries(String series) {
            this.series = series;
            return this;
        }


        public Builder setRemoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }


        public InternalCrowdRememberMeToken build() {
            return new InternalCrowdRememberMeToken(id, token, username, directoryId, createdTime, usedTime, series, remoteAddress);
        }
    }
}
