package com.atlassian.crowd.model.permission;

import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.user.InternalUser;
import com.google.common.base.MoreObjects;

import java.util.Objects;

public class UserAdministrationGrantToGroup {
    private Long id;
    private InternalUser user;
    private InternalGroup targetGroup;

    public UserAdministrationGrantToGroup() {
    }

    public UserAdministrationGrantToGroup(InternalUser user, InternalGroup targetGroup) {
        this.user = user;
        this.targetGroup = targetGroup;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public InternalUser getUser() {
        return user;
    }

    public void setUser(InternalUser user) {
        this.user = user;
    }

    public InternalGroup getTargetGroup() {
        return targetGroup;
    }

    public void setTargetGroup(InternalGroup targetGroup) {
        this.targetGroup = targetGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserAdministrationGrantToGroup that = (UserAdministrationGrantToGroup) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(user, that.user) &&
                Objects.equals(targetGroup, that.targetGroup);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, user, targetGroup);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("user", user)
                .add("targetGroup", targetGroup)
                .toString();
    }
}
