package com.atlassian.crowd.model.licensing;

import com.atlassian.crowd.model.ApplicationSubtype;
import com.atlassian.crowd.model.application.Application;

import java.util.Date;
import java.util.Objects;

/**
 * Some global information about application licensing.
 */
public class LicensingSummary {
    private Long id;
    private Date generatedOn;
    private long versionId;
    private Application application;
    private ApplicationSubtype applicationSubtype;
    private int totalUsers;
    private int totalUsersFromLocalCrowd;
    private boolean active;
    private int maximumUserLimit;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGeneratedOn() {
        return generatedOn;
    }

    public void setGeneratedOn(Date generatedOn) {
        this.generatedOn = generatedOn;
    }

    public long getVersionId() {
        return versionId;
    }

    public void setVersionId(long versionId) {
        this.versionId = versionId;
    }

    public Application getApplication() {
        return application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationSubtype getApplicationSubtype() {
        return applicationSubtype;
    }

    public void setApplicationSubtype(ApplicationSubtype applicationSubtype) {
        this.applicationSubtype = applicationSubtype;
    }

    public int getTotalUsers() {
        return totalUsers;
    }

    public void setTotalUsers(int totalUsers) {
        this.totalUsers = totalUsers;
    }

    public int getTotalUsersFromLocalCrowd() {
        return totalUsersFromLocalCrowd;
    }

    public void setTotalUsersFromLocalCrowd(int totalUsersFromLocalCrowd) {
        this.totalUsersFromLocalCrowd = totalUsersFromLocalCrowd;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getMaximumUserLimit() {
        return maximumUserLimit;
    }

    public void setMaximumUserLimit(int maximumUserLimit) {
        this.maximumUserLimit = maximumUserLimit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LicensingSummary that = (LicensingSummary) o;
        return versionId == that.versionId &&
                totalUsers == that.totalUsers &&
                totalUsersFromLocalCrowd == that.totalUsersFromLocalCrowd &&
                active == that.active &&
                maximumUserLimit == that.maximumUserLimit &&
                Objects.equals(id, that.id) &&
                Objects.equals(generatedOn, that.generatedOn) &&
                Objects.equals(application, that.application) &&
                applicationSubtype == that.applicationSubtype;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, generatedOn, versionId, application, applicationSubtype, totalUsers, totalUsersFromLocalCrowd, active, maximumUserLimit);
    }
}
