package com.atlassian.crowd.model.cluster;

import java.util.Objects;

public class ClusterInfoEntity {
    private String nodeId;
    private String ipAddress;
    private String hostname;
    private Long currentHeap;
    private Long maxHeap;
    private Double loadAverage;
    private Long uptime;
    private long infoTimestamp;

    protected ClusterInfoEntity() {
    }

    public ClusterInfoEntity(String nodeId, String ipAddress, String hostname, Long currentHeap, Long maxHeap, Double loadAverage, Long uptime, long infoTimestamp) {
        this.nodeId = nodeId;
        this.ipAddress = ipAddress;
        this.hostname = hostname;
        this.currentHeap = currentHeap;
        this.maxHeap = maxHeap;
        this.loadAverage = loadAverage;
        this.uptime = uptime;
        this.infoTimestamp = infoTimestamp;
    }

    public String getNodeId() {
        return nodeId;
    }

    protected void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    protected void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getHostname() {
        return hostname;
    }

    protected void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Long getCurrentHeap() {
        return currentHeap;
    }

    protected void setCurrentHeap(Long currentHeap) {
        this.currentHeap = currentHeap;
    }

    public Long getMaxHeap() {
        return maxHeap;
    }

    protected void setMaxHeap(Long maxHeap) {
        this.maxHeap = maxHeap;
    }

    public Double getLoadAverage() {
        return loadAverage;
    }

    protected void setLoadAverage(Double loadAverage) {
        this.loadAverage = loadAverage;
    }

    public Long getUptime() {
        return uptime;
    }

    protected void setUptime(Long uptime) {
        this.uptime = uptime;
    }

    public long getInfoTimestamp() {
        return infoTimestamp;
    }

    protected void setInfoTimestamp(long infoTimestamp) {
        this.infoTimestamp = infoTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClusterInfoEntity that = (ClusterInfoEntity) o;
        return infoTimestamp == that.infoTimestamp &&
                Objects.equals(nodeId, that.nodeId) &&
                Objects.equals(ipAddress, that.ipAddress) &&
                Objects.equals(hostname, that.hostname) &&
                Objects.equals(currentHeap, that.currentHeap) &&
                Objects.equals(maxHeap, that.maxHeap) &&
                Objects.equals(loadAverage, that.loadAverage) &&
                Objects.equals(uptime, that.uptime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nodeId, ipAddress, hostname, currentHeap, maxHeap, loadAverage, uptime, infoTimestamp);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("ClusterInfoEntity{");
        sb.append("nodeId='").append(nodeId).append('\'');
        sb.append(", ipAddress='").append(ipAddress).append('\'');
        sb.append(", hostname='").append(hostname).append('\'');
        sb.append(", currentHeap=").append(currentHeap);
        sb.append(", maxHeap=").append(maxHeap);
        sb.append(", loadAverage=").append(loadAverage);
        sb.append(", uptime=").append(uptime);
        sb.append(", infoTimestamp=").append(infoTimestamp);
        sb.append('}');
        return sb.toString();
    }
}