package com.atlassian.crowd.model.cluster;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class ClusterHeartbeatEntity {
    private String nodeId;
    private String nodeName;
    private long timestamp;

    protected ClusterHeartbeatEntity() {
    }

    public ClusterHeartbeatEntity(String nodeId, String nodeName, long timestamp) {
        this.nodeId = nodeId;
        this.timestamp = timestamp;
        this.nodeName = nodeName;
    }

    public String getNodeId() {
        return nodeId;
    }

    protected void setNodeId(String nodeid) {
        this.nodeId = nodeid;
    }

    public long getTimestamp() {
        return timestamp;
    }

    protected void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getNodeName() {
        return nodeName;
    }

    protected void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClusterHeartbeatEntity that = (ClusterHeartbeatEntity) o;
        return timestamp == that.timestamp &&
                Objects.equals(nodeId, that.nodeId) &&
                Objects.equals(nodeName, that.nodeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nodeId, nodeName, timestamp);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("nodeId", nodeId)
                .add("nodeName", nodeName)
                .add("timestamp", timestamp)
                .toString();
    }
}