package com.atlassian.crowd.dao.application;

import com.atlassian.crowd.model.application.AppIssuesWithMailScanResultEntity;

import java.util.Optional;

/**
 * Manages persistence of {@link AppIssuesWithMailScanResultEntity}.
 */
public interface AppIssuesWithMailsScanResultDAO {
    /**
     * Persists scan result for a given application. Overrides old scan result for given app if exists.
     *
     * @param appIssuesWithMailScanResultEntity scan result entity
     */
    void persistLatestResult(AppIssuesWithMailScanResultEntity appIssuesWithMailScanResultEntity);

    /**
     * Gets latest scan result for a given application.
     *
     * @param appId application ID
     * @return optional containing scan results or empty optional if no scan results found
     */
    Optional<AppIssuesWithMailScanResultEntity> getLatestResult(long appId);

    /**
     * Removes latest scan result for a given application. Does nothing when there is no scan result present.
     *
     * @param appId application ID
     */
    void removeLatestResultIfPresent(long appId);
}
