package com.atlassian.crowd.util.persistence.hibernate.batch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchConfigParser {
    public static final int DEFAULT_QUERY_IN_BATCH_SIZE = 1000;
    private static final String PROPERTY_KEY = "crowd.query.in.batch.size";

    private static final Logger log = LoggerFactory.getLogger(BatchConfigParser.class);

    public int getCrowdQueryBatchSize() {
        final Integer crowdQueryInBatchSize = Integer.getInteger(PROPERTY_KEY, DEFAULT_QUERY_IN_BATCH_SIZE);

        if (crowdQueryInBatchSize < 0) {
            log.warn("Invalid value '{}' specified for property '{}', using default batch size: '{}'",
                    crowdQueryInBatchSize, PROPERTY_KEY, DEFAULT_QUERY_IN_BATCH_SIZE);
            return DEFAULT_QUERY_IN_BATCH_SIZE;
        }

        return crowdQueryInBatchSize;
    }
}
