package com.atlassian.crowd.search.hibernate.audit;

import com.google.common.annotations.VisibleForTesting;

import static com.atlassian.crowd.common.properties.SystemProperties.AUDITLOG_SEARCH_ESCAPE_SPECIAL_CHARACTERS_ENABLED;

public class PrefixRestriction extends SimpleRestriction {
    public PrefixRestriction(String property, String value) {
        super(property, "LIKE", sanitizePrefix(value) + "%");
    }

    @VisibleForTesting
    static String sanitizePrefix(String prefix) {
        return AUDITLOG_SEARCH_ESCAPE_SPECIAL_CHARACTERS_ENABLED.getValue()
                ? prefix.replaceAll("[_]", "\\\\_").replaceAll("[%]", "")
                : prefix.replaceAll("[%_]", "");
    }
}